/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentTextDetectionResponse extends TextractResponse implements
        ToCopyableBuilder<GetDocumentTextDetectionResponse.Builder, GetDocumentTextDetectionResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(GetDocumentTextDetectionResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetDocumentTextDetectionResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDocumentTextDetectionResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField
            .<List<Block>> builder(MarshallingType.LIST)
            .memberName("Blocks")
            .getter(getter(GetDocumentTextDetectionResponse::blocks))
            .setter(setter(Builder::blocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Block> builder(MarshallingType.SDK_POJO)
                                            .constructor(Block::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField
            .<List<Warning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(GetDocumentTextDetectionResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Warning> builder(MarshallingType.SDK_POJO)
                                            .constructor(Warning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetDocumentTextDetectionResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DetectDocumentTextModelVersion")
            .getter(getter(GetDocumentTextDetectionResponse::detectDocumentTextModelVersion))
            .setter(setter(Builder::detectDocumentTextModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectDocumentTextModelVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD,
            JOB_STATUS_FIELD, NEXT_TOKEN_FIELD, BLOCKS_FIELD, WARNINGS_FIELD, STATUS_MESSAGE_FIELD,
            DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD));

    private final DocumentMetadata documentMetadata;

    private final String jobStatus;

    private final String nextToken;

    private final List<Block> blocks;

    private final List<Warning> warnings;

    private final String statusMessage;

    private final String detectDocumentTextModelVersion;

    private GetDocumentTextDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.jobStatus = builder.jobStatus;
        this.nextToken = builder.nextToken;
        this.blocks = builder.blocks;
        this.warnings = builder.warnings;
        this.statusMessage = builder.statusMessage;
        this.detectDocumentTextModelVersion = builder.detectDocumentTextModelVersion;
    }

    /**
     * <p>
     * Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in every
     * page of paginated responses from an Amazon Textract video operation.
     * </p>
     * 
     * @return Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in
     *         every page of paginated responses from an Amazon Textract video operation.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * <p>
     * The current status of the text detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the text detection job.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the text detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the text detection job.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Textract returns this token. You can use this token in the subsequent
     * request to retrieve the next set of text-detection results.
     * </p>
     * 
     * @return If the response is truncated, Amazon Textract returns this token. You can use this token in the
     *         subsequent request to retrieve the next set of text-detection results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Blocks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBlocks() {
        return blocks != null && !(blocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the text-detection operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlocks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The results of the text-detection operation.
     */
    public final List<Block> blocks() {
        return blocks;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of warnings that occurred during the text-detection operation for the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of warnings that occurred during the text-detection operation for the document.
     */
    public final List<Warning> warnings() {
        return warnings;
    }

    /**
     * <p>
     * Returns if the detection job could not be completed. Contains explanation for what error occured.
     * </p>
     * 
     * @return Returns if the detection job could not be completed. Contains explanation for what error occured.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String detectDocumentTextModelVersion() {
        return detectDocumentTextModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocks() ? blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(detectDocumentTextModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentTextDetectionResponse)) {
            return false;
        }
        GetDocumentTextDetectionResponse other = (GetDocumentTextDetectionResponse) obj;
        return Objects.equals(documentMetadata(), other.documentMetadata())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && hasBlocks() == other.hasBlocks()
                && Objects.equals(blocks(), other.blocks()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(detectDocumentTextModelVersion(), other.detectDocumentTextModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentTextDetectionResponse").add("DocumentMetadata", documentMetadata())
                .add("JobStatus", jobStatusAsString()).add("NextToken", nextToken()).add("Blocks", hasBlocks() ? blocks() : null)
                .add("Warnings", hasWarnings() ? warnings() : null).add("StatusMessage", statusMessage())
                .add("DetectDocumentTextModelVersion", detectDocumentTextModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Blocks":
            return Optional.ofNullable(clazz.cast(blocks()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "DetectDocumentTextModelVersion":
            return Optional.ofNullable(clazz.cast(detectDocumentTextModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentTextDetectionResponse, T> g) {
        return obj -> g.apply((GetDocumentTextDetectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDocumentTextDetectionResponse> {
        /**
         * <p>
         * Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in
         * every page of paginated responses from an Amazon Textract video operation.
         * </p>
         * 
         * @param documentMetadata
         *        Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned
         *        in every page of paginated responses from an Amazon Textract video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * <p>
         * Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in
         * every page of paginated responses from an Amazon Textract video operation.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentMetadata.Builder} avoiding the need to
         * create one manually via {@link DocumentMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The current status of the text detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the text detection job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the text detection job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the text detection job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * If the response is truncated, Amazon Textract returns this token. You can use this token in the subsequent
         * request to retrieve the next set of text-detection results.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Textract returns this token. You can use this token in the
         *        subsequent request to retrieve the next set of text-detection results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The results of the text-detection operation.
         * </p>
         * 
         * @param blocks
         *        The results of the text-detection operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Collection<Block> blocks);

        /**
         * <p>
         * The results of the text-detection operation.
         * </p>
         * 
         * @param blocks
         *        The results of the text-detection operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Block... blocks);

        /**
         * <p>
         * The results of the text-detection operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Block>.Builder} avoiding the need to create
         * one manually via {@link List<Block>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Block>.Builder#build()} is called immediately and its result
         * is passed to {@link #blocks(List<Block>)}.
         * 
         * @param blocks
         *        a consumer that will call methods on {@link List<Block>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocks(List<Block>)
         */
        Builder blocks(Consumer<Block.Builder>... blocks);

        /**
         * <p>
         * A list of warnings that occurred during the text-detection operation for the document.
         * </p>
         * 
         * @param warnings
         *        A list of warnings that occurred during the text-detection operation for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<Warning> warnings);

        /**
         * <p>
         * A list of warnings that occurred during the text-detection operation for the document.
         * </p>
         * 
         * @param warnings
         *        A list of warnings that occurred during the text-detection operation for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Warning... warnings);

        /**
         * <p>
         * A list of warnings that occurred during the text-detection operation for the document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Warning>.Builder} avoiding the need to
         * create one manually via {@link List<Warning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Warning>.Builder#build()} is called immediately and its
         * result is passed to {@link #warnings(List<Warning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on {@link List<Warning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(List<Warning>)
         */
        Builder warnings(Consumer<Warning.Builder>... warnings);

        /**
         * <p>
         * Returns if the detection job could not be completed. Contains explanation for what error occured.
         * </p>
         * 
         * @param statusMessage
         *        Returns if the detection job could not be completed. Contains explanation for what error occured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p/>
         * 
         * @param detectDocumentTextModelVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectDocumentTextModelVersion(String detectDocumentTextModelVersion);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private DocumentMetadata documentMetadata;

        private String jobStatus;

        private String nextToken;

        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();

        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private String statusMessage;

        private String detectDocumentTextModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentTextDetectionResponse model) {
            super(model);
            documentMetadata(model.documentMetadata);
            jobStatus(model.jobStatus);
            nextToken(model.nextToken);
            blocks(model.blocks);
            warnings(model.warnings);
            statusMessage(model.statusMessage);
            detectDocumentTextModelVersion(model.detectDocumentTextModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Block.Builder> getBlocks() {
            if (blocks instanceof SdkAutoConstructList) {
                return null;
            }
            return blocks != null ? blocks.stream().map(Block::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block... blocks) {
            blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder>... blocks) {
            blocks(Stream.of(blocks).map(c -> Block.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        public final Collection<Warning.Builder> getWarnings() {
            if (warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return warnings != null ? warnings.stream().map(Warning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> Warning.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getDetectDocumentTextModelVersion() {
            return detectDocumentTextModelVersion;
        }

        @Override
        public final Builder detectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
            return this;
        }

        public final void setDetectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
        }

        @Override
        public GetDocumentTextDetectionResponse build() {
            return new GetDocumentTextDetectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
