/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlockType {
    KEY_VALUE_SET("KEY_VALUE_SET"),
    PAGE("PAGE"),
    LINE("LINE"),
    WORD("WORD"),
    TABLE("TABLE"),
    CELL("CELL"),
    SELECTION_ELEMENT("SELECTION_ELEMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BlockType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BlockType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockType> knownValues() {
        return Stream.of(BlockType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

