/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import software.amazon.awssdk.utils.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static void cleanUpTestDirectory(Path directory) {
        if (directory == null) {
            return;
        }
        try (Stream<Path> paths = Files.walk(directory, Integer.MAX_VALUE, FileVisitOption.FOLLOW_LINKS);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyDirectory(final Path source, final Path destination, final CopyOption ... options) {
        try {
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(this.mirror(dir), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, this.mirror(file), options);
                    return FileVisitResult.CONTINUE;
                }

                private Path mirror(Path path) {
                    Path relativePath = source.relativize(path);
                    return destination.resolve(relativePath);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to copy %s to %s", source, destination), e);
        }
    }

    public static String toFileTreeString(Path root) {
        int rootDepth = root.getNameCount();
        String tab = StringUtils.repeat((String)" ", (int)4);
        StringBuilder sb = new StringBuilder();
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
            files.forEach(p -> {
                int indentLevel = p.getNameCount() - rootDepth;
                String line = String.format("%s- %s", StringUtils.repeat((String)tab, (int)indentLevel), p.getFileName());
                sb.append(line);
                sb.append(System.lineSeparator());
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to convert %s to file tree", root), e);
        }
        return sb.toString();
    }
}

