/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import software.amazon.awssdk.utils.IoUtils;

public class InputStreamUtils {
    public static byte[] calculateMD5Digest(InputStream is) throws NoSuchAlgorithmException, IOException {
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while ((bytesRead = is.read(buffer)) != -1) {
            md5.update(buffer, 0, bytesRead);
        }
        return md5.digest();
    }

    public static byte[] drainInputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            long bytesRead = 0L;
            while ((bytesRead = (long)inputStream.read(buffer)) > -1L) {
                byteArrayOutputStream.write(buffer, 0, (int)bytesRead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)byteArrayOutputStream, null);
        }
    }
}

