/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.retry;

import java.util.concurrent.Callable;
import software.amazon.awssdk.test.retry.NonRetryableException;
import software.amazon.awssdk.test.retry.RetryableError;
import software.amazon.awssdk.test.retry.RetryableParams;
import software.amazon.awssdk.util.ValidationUtils;

public class RetryableAction<T> {
    private final Callable<T> delegate;
    private final RetryableParams params;

    private RetryableAction(Callable<T> delegate, RetryableParams params) {
        this.delegate = delegate;
        this.params = params;
    }

    public static <T> T doRetryableAction(Callable<T> callable, RetryableParams params) throws Exception {
        ValidationUtils.assertIsPositive((int)params.getMaxAttempts(), (String)"maxAttempts");
        return super.call();
    }

    private T call() throws Exception {
        return this.call(this.params.getMaxAttempts());
    }

    private T call(int remainingAttempts) throws Exception {
        try {
            if (this.params.getMaxAttempts() != remainingAttempts) {
                this.delay();
            }
            return this.delegate.call();
        }
        catch (RetryableError e) {
            if (this.shouldNotRetry(remainingAttempts - 1)) {
                throw e.getCause();
            }
            return this.call(remainingAttempts - 1);
        }
        catch (NonRetryableException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            if (this.shouldNotRetry(remainingAttempts - 1)) {
                throw e;
            }
            return this.call(remainingAttempts - 1);
        }
    }

    private boolean shouldNotRetry(int remainingAttempts) {
        return remainingAttempts <= 0;
    }

    private void delay() throws InterruptedException {
        if (this.params.getDelayInMs() > 0) {
            Thread.sleep(this.params.getDelayInMs());
        }
    }
}

