/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.retry;

import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.util.ValidationUtils;

public class RetryRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(RetryRule.class);
    private int maxRetryAttempts;
    private long delay;
    private TimeUnit timeUnit;

    public RetryRule(int maxRetryAttempts) {
        this(maxRetryAttempts, 0L, TimeUnit.SECONDS);
    }

    public RetryRule(int maxRetryAttempts, long delay, TimeUnit timeUnit) {
        this.maxRetryAttempts = maxRetryAttempts;
        this.delay = delay;
        this.timeUnit = (TimeUnit)((Object)ValidationUtils.assertNotNull((Object)((Object)timeUnit), (String)"timeUnit"));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.retry(base, 1);
            }

            public void retry(Statement base2, int attempts) throws Throwable {
                try {
                    base2.evaluate();
                }
                catch (Exception e) {
                    if (attempts > RetryRule.this.maxRetryAttempts) {
                        throw e;
                    }
                    log.warn("Test failed. Retrying with delay of: {} {}", (Object)RetryRule.this.delay, (Object)RetryRule.this.timeUnit);
                    RetryRule.this.timeUnit.sleep(RetryRule.this.delay);
                    this.retry(base2, ++attempts);
                }
            }
        };
    }
}

