/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.supportapp.SupportAppClient;
import software.amazon.awssdk.services.supportapp.SupportAppServiceClientConfiguration;
import software.amazon.awssdk.services.supportapp.model.AccessDeniedException;
import software.amazon.awssdk.services.supportapp.model.ConflictException;
import software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.DeleteSlackWorkspaceConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.GetAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.GetAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.InternalServerException;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse;
import software.amazon.awssdk.services.supportapp.model.PutAccountAliasRequest;
import software.amazon.awssdk.services.supportapp.model.PutAccountAliasResponse;
import software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest;
import software.amazon.awssdk.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse;
import software.amazon.awssdk.services.supportapp.model.ResourceNotFoundException;
import software.amazon.awssdk.services.supportapp.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.supportapp.model.SupportAppException;
import software.amazon.awssdk.services.supportapp.model.SupportAppRequest;
import software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.supportapp.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.supportapp.model.ValidationException;
import software.amazon.awssdk.services.supportapp.paginators.ListSlackChannelConfigurationsIterable;
import software.amazon.awssdk.services.supportapp.paginators.ListSlackWorkspaceConfigurationsIterable;
import software.amazon.awssdk.services.supportapp.transform.CreateSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.DeleteAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.DeleteSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.DeleteSlackWorkspaceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.GetAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.ListSlackChannelConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.ListSlackWorkspaceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.PutAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.RegisterSlackWorkspaceForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.supportapp.transform.UpdateSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSupportAppClient
implements SupportAppClient {
    private static final Logger log = Logger.loggerFor(DefaultSupportAppClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final SupportAppServiceClientConfiguration serviceClientConfiguration;

    protected DefaultSupportAppClient(SupportAppServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSlackChannelConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, createSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSlackChannelConfiguration");
            CreateSlackChannelConfigurationResponse createSlackChannelConfigurationResponse = (CreateSlackChannelConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSlackChannelConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSlackChannelConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSlackChannelConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSlackChannelConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$createSlackChannelConfiguration$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccountAliasResponse deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest) throws ResourceNotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, deleteAccountAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccountAlias");
            DeleteAccountAliasResponse deleteAccountAliasResponse = (DeleteAccountAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccountAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAccountAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccountAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccountAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$deleteAccountAlias$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSlackChannelConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, deleteSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSlackChannelConfiguration");
            DeleteSlackChannelConfigurationResponse deleteSlackChannelConfigurationResponse = (DeleteSlackChannelConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSlackChannelConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSlackChannelConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSlackChannelConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSlackChannelConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$deleteSlackChannelConfiguration$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSlackWorkspaceConfigurationResponse deleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest deleteSlackWorkspaceConfigurationRequest) throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSlackWorkspaceConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, deleteSlackWorkspaceConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSlackWorkspaceConfiguration");
            DeleteSlackWorkspaceConfigurationResponse deleteSlackWorkspaceConfigurationResponse = (DeleteSlackWorkspaceConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSlackWorkspaceConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSlackWorkspaceConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSlackWorkspaceConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSlackWorkspaceConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$deleteSlackWorkspaceConfiguration$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountAliasResponse getAccountAlias(GetAccountAliasRequest getAccountAliasRequest) throws InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, getAccountAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountAlias");
            GetAccountAliasResponse getAccountAliasResponse = (GetAccountAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$getAccountAlias$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSlackChannelConfigurationsResponse listSlackChannelConfigurations(ListSlackChannelConfigurationsRequest listSlackChannelConfigurationsRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSlackChannelConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, listSlackChannelConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSlackChannelConfigurations");
            ListSlackChannelConfigurationsResponse listSlackChannelConfigurationsResponse = (ListSlackChannelConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSlackChannelConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSlackChannelConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSlackChannelConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSlackChannelConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$listSlackChannelConfigurations$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSlackChannelConfigurationsIterable listSlackChannelConfigurationsPaginator(ListSlackChannelConfigurationsRequest listSlackChannelConfigurationsRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return new ListSlackChannelConfigurationsIterable(this, this.applyPaginatorUserAgent(listSlackChannelConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSlackWorkspaceConfigurationsResponse listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest listSlackWorkspaceConfigurationsRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSlackWorkspaceConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, listSlackWorkspaceConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSlackWorkspaceConfigurations");
            ListSlackWorkspaceConfigurationsResponse listSlackWorkspaceConfigurationsResponse = (ListSlackWorkspaceConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSlackWorkspaceConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSlackWorkspaceConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSlackWorkspaceConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSlackWorkspaceConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$listSlackWorkspaceConfigurations$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSlackWorkspaceConfigurationsIterable listSlackWorkspaceConfigurationsPaginator(ListSlackWorkspaceConfigurationsRequest listSlackWorkspaceConfigurationsRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, SupportAppException {
        return new ListSlackWorkspaceConfigurationsIterable(this, this.applyPaginatorUserAgent(listSlackWorkspaceConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountAliasResponse putAccountAlias(PutAccountAliasRequest putAccountAliasRequest) throws AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, putAccountAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountAlias");
            PutAccountAliasResponse putAccountAliasResponse = (PutAccountAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$putAccountAlias$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterSlackWorkspaceForOrganizationResponse registerSlackWorkspaceForOrganization(RegisterSlackWorkspaceForOrganizationRequest registerSlackWorkspaceForOrganizationRequest) throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterSlackWorkspaceForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, registerSlackWorkspaceForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterSlackWorkspaceForOrganization");
            RegisterSlackWorkspaceForOrganizationResponse registerSlackWorkspaceForOrganizationResponse = (RegisterSlackWorkspaceForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterSlackWorkspaceForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerSlackWorkspaceForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterSlackWorkspaceForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerSlackWorkspaceForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$registerSlackWorkspaceForOrganization$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) throws ConflictException, ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, SupportAppException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSlackChannelConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSupportAppClient.resolveMetricPublishers(this.clientConfiguration, updateSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Support App");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSlackChannelConfiguration");
            UpdateSlackChannelConfigurationResponse updateSlackChannelConfigurationResponse = (UpdateSlackChannelConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSlackChannelConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSlackChannelConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSlackChannelConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSlackChannelConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSupportAppClient.lambda$updateSlackChannelConfiguration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends SupportAppRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.91").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SupportAppRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "supportapp";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SupportAppException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final SupportAppServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSlackChannelConfiguration$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerSlackWorkspaceForOrganization$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountAlias$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSlackWorkspaceConfigurations$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSlackChannelConfigurations$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountAlias$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSlackWorkspaceConfiguration$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSlackChannelConfiguration$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccountAlias$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSlackChannelConfiguration$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

