/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.supportapp.DefaultSupportAppAsyncClient;
import software.amazon.awssdk.services.supportapp.DefaultSupportAppBaseClientBuilder;
import software.amazon.awssdk.services.supportapp.SupportAppAsyncClient;
import software.amazon.awssdk.services.supportapp.SupportAppAsyncClientBuilder;
import software.amazon.awssdk.services.supportapp.SupportAppServiceClientConfiguration;
import software.amazon.awssdk.services.supportapp.endpoints.SupportAppEndpointProvider;

@SdkInternalApi
final class DefaultSupportAppAsyncClientBuilder
extends DefaultSupportAppBaseClientBuilder<SupportAppAsyncClientBuilder, SupportAppAsyncClient>
implements SupportAppAsyncClientBuilder {
    DefaultSupportAppAsyncClientBuilder() {
    }

    @Override
    public DefaultSupportAppAsyncClientBuilder endpointProvider(SupportAppEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SupportAppAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSupportAppAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SupportAppServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSupportAppAsyncClient client = new DefaultSupportAppAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SupportAppServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SupportAppServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

