/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supportapp.SupportAppAsyncClient;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.supportapp.model.ListSlackChannelConfigurationsResponse;

public class ListSlackChannelConfigurationsPublisher
implements SdkPublisher<ListSlackChannelConfigurationsResponse> {
    private final SupportAppAsyncClient client;
    private final ListSlackChannelConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSlackChannelConfigurationsPublisher(SupportAppAsyncClient client, ListSlackChannelConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSlackChannelConfigurationsPublisher(SupportAppAsyncClient client, ListSlackChannelConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSlackChannelConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSlackChannelConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSlackChannelConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListSlackChannelConfigurationsResponse> {
        private ListSlackChannelConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlackChannelConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSlackChannelConfigurationsResponse> nextPage(ListSlackChannelConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSlackChannelConfigurationsPublisher.this.client.listSlackChannelConfigurations(ListSlackChannelConfigurationsPublisher.this.firstRequest);
            }
            return ListSlackChannelConfigurationsPublisher.this.client.listSlackChannelConfigurations((ListSlackChannelConfigurationsRequest)((Object)ListSlackChannelConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

