/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.AttachmentDetails;
import software.amazon.awssdk.services.support.model.AttachmentSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Communication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Communication> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Communication.getter(Communication::caseId)).setter(Communication.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Communication.getter(Communication::body)).setter(Communication.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> SUBMITTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Communication.getter(Communication::submittedBy)).setter(Communication.setter(Builder::submittedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedBy").build()}).build();
    private static final SdkField<String> TIME_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Communication.getter(Communication::timeCreated)).setter(Communication.setter(Builder::timeCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeCreated").build()}).build();
    private static final SdkField<List<AttachmentDetails>> ATTACHMENT_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Communication.getter(Communication::attachmentSet)).setter(Communication.setter(Builder::attachmentSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, BODY_FIELD, SUBMITTED_BY_FIELD, TIME_CREATED_FIELD, ATTACHMENT_SET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String caseId;
    private final String body;
    private final String submittedBy;
    private final String timeCreated;
    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    public String caseId() {
        return this.caseId;
    }

    public String body() {
        return this.body;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public List<AttachmentDetails> attachmentSet() {
        return this.attachmentSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication)obj;
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.submittedBy(), other.submittedBy()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.attachmentSet(), other.attachmentSet());
    }

    public String toString() {
        return ToString.builder((String)"Communication").add("CaseId", (Object)this.caseId()).add("Body", (Object)this.body()).add("SubmittedBy", (Object)this.submittedBy()).add("TimeCreated", (Object)this.timeCreated()).add("AttachmentSet", this.attachmentSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "submittedBy": {
                return Optional.ofNullable(clazz.cast(this.submittedBy()));
            }
            case "timeCreated": {
                return Optional.ofNullable(clazz.cast(this.timeCreated()));
            }
            case "attachmentSet": {
                return Optional.ofNullable(clazz.cast(this.attachmentSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Communication, T> g) {
        return obj -> g.apply((Communication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String body;
        private String submittedBy;
        private String timeCreated;
        private List<AttachmentDetails> attachmentSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            this.caseId(model.caseId);
            this.body(model.body);
            this.submittedBy(model.submittedBy);
            this.timeCreated(model.timeCreated);
            this.attachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final Collection<AttachmentDetails.Builder> getAttachmentSet() {
            return this.attachmentSet != null ? (Collection)this.attachmentSet.stream().map(AttachmentDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails ... attachmentSet) {
            this.attachmentSet(Arrays.asList(attachmentSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(Consumer<AttachmentDetails.Builder> ... attachmentSet) {
            this.attachmentSet(Stream.of(attachmentSet).map(c -> (AttachmentDetails)((AttachmentDetails.Builder)AttachmentDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails.BuilderImpl> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copyFromBuilder(attachmentSet);
        }

        public Communication build() {
            return new Communication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Communication> {
        public Builder caseId(String var1);

        public Builder body(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder attachmentSet(Collection<AttachmentDetails> var1);

        public Builder attachmentSet(AttachmentDetails ... var1);

        public Builder attachmentSet(Consumer<AttachmentDetails.Builder> ... var1);
    }
}

