/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a resource identified by a Trusted Advisor check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorResourceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorResourceDetail.Builder, TrustedAdvisorResourceDetail> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrustedAdvisorResourceDetail::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(TrustedAdvisorResourceDetail::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(TrustedAdvisorResourceDetail::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<Boolean> IS_SUPPRESSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSuppressed").getter(getter(TrustedAdvisorResourceDetail::isSuppressed))
            .setter(setter(Builder::isSuppressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSuppressed").build()).build();

    private static final SdkField<List<String>> METADATA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metadata")
            .getter(getter(TrustedAdvisorResourceDetail::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REGION_FIELD,
            RESOURCE_ID_FIELD, IS_SUPPRESSED_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String region;

    private final String resourceId;

    private final Boolean isSuppressed;

    private final List<String> metadata;

    private TrustedAdvisorResourceDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.isSuppressed = builder.isSuppressed;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The status code for the resource identified in the Trusted Advisor check.
     * </p>
     * 
     * @return The status code for the resource identified in the Trusted Advisor check.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the identified resource is located.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the identified resource is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The unique identifier for the identified resource.
     * </p>
     * 
     * @return The unique identifier for the identified resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as
     * suppressed by the user.
     * </p>
     * 
     * @return Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked
     *         as suppressed by the user.
     */
    public final Boolean isSuppressed() {
        return isSuppressed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional information about the identified resource. The exact metadata and its order can be obtained by
     * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
     * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel download,
     * even in those cases where the UI shows just summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Additional information about the identified resource. The exact metadata and its order can be obtained by
     *         inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
     *         <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
     *         download, even in those cases where the UI shows just summary data.
     */
    public final List<String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(isSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourceDetail)) {
            return false;
        }
        TrustedAdvisorResourceDetail other = (TrustedAdvisorResourceDetail) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(region(), other.region())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(isSuppressed(), other.isSuppressed())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedAdvisorResourceDetail").add("Status", status()).add("Region", region())
                .add("ResourceId", resourceId()).add("IsSuppressed", isSuppressed())
                .add("Metadata", hasMetadata() ? metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "isSuppressed":
            return Optional.ofNullable(clazz.cast(isSuppressed()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("region", REGION_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("isSuppressed", IS_SUPPRESSED_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorResourceDetail, T> g) {
        return obj -> g.apply((TrustedAdvisorResourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
        /**
         * <p>
         * The status code for the resource identified in the Trusted Advisor check.
         * </p>
         * 
         * @param status
         *        The status code for the resource identified in the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Amazon Web Services Region in which the identified resource is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region in which the identified resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The unique identifier for the identified resource.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the identified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as
         * suppressed by the user.
         * </p>
         * 
         * @param isSuppressed
         *        Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was
         *        marked as suppressed by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSuppressed(Boolean isSuppressed);

        /**
         * <p>
         * Additional information about the identified resource. The exact metadata and its order can be obtained by
         * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         * download, even in those cases where the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        Additional information about the identified resource. The exact metadata and its order can be obtained
         *        by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         *        <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         *        download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Collection<String> metadata);

        /**
         * <p>
         * Additional information about the identified resource. The exact metadata and its order can be obtained by
         * inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         * <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         * download, even in those cases where the UI shows just summary data.
         * </p>
         * 
         * @param metadata
         *        Additional information about the identified resource. The exact metadata and its order can be obtained
         *        by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to
         *        <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel
         *        download, even in those cases where the UI shows just summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String... metadata);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String region;

        private String resourceId;

        private Boolean isSuppressed;

        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourceDetail model) {
            status(model.status);
            region(model.region);
            resourceId(model.resourceId);
            isSuppressed(model.isSuppressed);
            metadata(model.metadata);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Boolean getIsSuppressed() {
            return isSuppressed;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public final Collection<String> getMetadata() {
            if (metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String... metadata) {
            metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        public TrustedAdvisorResourceDetail build() {
            return new TrustedAdvisorResourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
