/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon Web Services service returned by the <a>DescribeServices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(Service::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Service::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .memberName("categories")
            .getter(getter(Service::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD,
            CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String name;

    private final List<Category> categories;

    private Service(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The code for an Amazon Web Services service returned by the <a>DescribeServices</a> response. The
     * <code>name</code> element contains the corresponding friendly name.
     * </p>
     * 
     * @return The code for an Amazon Web Services service returned by the <a>DescribeServices</a> response. The
     *         <code>name</code> element contains the corresponding friendly name.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding
     * code.
     * </p>
     * 
     * @return The friendly name for an Amazon Web Services service. The <code>code</code> element contains the
     *         corresponding code.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of categories that describe the type of support issue a case describes. Categories consist of a category
     * name and a category code. Category names and codes are passed to Amazon Web Services Support when you call
     * <a>CreateCase</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return A list of categories that describe the type of support issue a case describes. Categories consist of a
     *         category name and a category code. Category names and codes are passed to Amazon Web Services Support
     *         when you call <a>CreateCase</a>.
     */
    public final List<Category> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(name(), other.name())
                && hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("Code", code()).add("Name", name())
                .add("Categories", hasCategories() ? categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The code for an Amazon Web Services service returned by the <a>DescribeServices</a> response. The
         * <code>name</code> element contains the corresponding friendly name.
         * </p>
         * 
         * @param code
         *        The code for an Amazon Web Services service returned by the <a>DescribeServices</a> response. The
         *        <code>name</code> element contains the corresponding friendly name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The friendly name for an Amazon Web Services service. The <code>code</code> element contains the
         * corresponding code.
         * </p>
         * 
         * @param name
         *        The friendly name for an Amazon Web Services service. The <code>code</code> element contains the
         *        corresponding code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to Amazon Web Services Support when
         * you call <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to Amazon Web Services Support
         *        when you call <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to Amazon Web Services Support when
         * you call <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to Amazon Web Services Support
         *        when you call <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to Amazon Web Services Support when
         * you call <a>CreateCase</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.Category.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.support.model.Category#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.Category.Builder#build()} is called immediately and its
         * result is passed to {@link #categories(List<Category>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.Category.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<Category>)
         */
        Builder categories(Consumer<Category.Builder>... categories);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String name;

        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            code(model.code);
            name(model.name);
            categories(model.categories);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder>... categories) {
            categories(Stream.of(categories).map(c -> Category.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
