/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustedAdvisorResourceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TrustedAdvisorResourceDetail.getter(TrustedAdvisorResourceDetail::status)).setter(TrustedAdvisorResourceDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(TrustedAdvisorResourceDetail.getter(TrustedAdvisorResourceDetail::region)).setter(TrustedAdvisorResourceDetail.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(TrustedAdvisorResourceDetail.getter(TrustedAdvisorResourceDetail::resourceId)).setter(TrustedAdvisorResourceDetail.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<Boolean> IS_SUPPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSuppressed").getter(TrustedAdvisorResourceDetail.getter(TrustedAdvisorResourceDetail::isSuppressed)).setter(TrustedAdvisorResourceDetail.setter(Builder::isSuppressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSuppressed").build()}).build();
    private static final SdkField<List<String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadata").getter(TrustedAdvisorResourceDetail.getter(TrustedAdvisorResourceDetail::metadata)).setter(TrustedAdvisorResourceDetail.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REGION_FIELD, RESOURCE_ID_FIELD, IS_SUPPRESSED_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustedAdvisorResourceDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String region;
    private final String resourceId;
    private final Boolean isSuppressed;
    private final List<String> metadata;

    private TrustedAdvisorResourceDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.isSuppressed = builder.isSuppressed;
        this.metadata = builder.metadata;
    }

    public final String status() {
        return this.status;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Boolean isSuppressed() {
        return this.isSuppressed;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructList);
    }

    public final List<String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourceDetail)) {
            return false;
        }
        TrustedAdvisorResourceDetail other = (TrustedAdvisorResourceDetail)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.isSuppressed(), other.isSuppressed()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"TrustedAdvisorResourceDetail").add("Status", (Object)this.status()).add("Region", (Object)this.region()).add("ResourceId", (Object)this.resourceId()).add("IsSuppressed", (Object)this.isSuppressed()).add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "isSuppressed": {
                return Optional.ofNullable(clazz.cast(this.isSuppressed()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("region", REGION_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("isSuppressed", IS_SUPPRESSED_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorResourceDetail, T> g) {
        return obj -> g.apply((TrustedAdvisorResourceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String region;
        private String resourceId;
        private Boolean isSuppressed;
        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourceDetail model) {
            this.status(model.status);
            this.region(model.region);
            this.resourceId(model.resourceId);
            this.isSuppressed(model.isSuppressed);
            this.metadata(model.metadata);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Boolean getIsSuppressed() {
            return this.isSuppressed;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public final Collection<String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public TrustedAdvisorResourceDetail build() {
            return new TrustedAdvisorResourceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
        public Builder status(String var1);

        public Builder region(String var1);

        public Builder resourceId(String var1);

        public Builder isSuppressed(Boolean var1);

        public Builder metadata(Collection<String> var1);

        public Builder metadata(String ... var1);
    }
}

