/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckDescription;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedAdvisorChecksResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
    private static final SdkField<List<TrustedAdvisorCheckDescription>> CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("checks").getter(DescribeTrustedAdvisorChecksResponse.getter(DescribeTrustedAdvisorChecksResponse::checks)).setter(DescribeTrustedAdvisorChecksResponse.setter(Builder::checks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedAdvisorCheckDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrustedAdvisorChecksResponse.memberNameToFieldInitializer();
    private final List<TrustedAdvisorCheckDescription> checks;

    private DescribeTrustedAdvisorChecksResponse(BuilderImpl builder) {
        super(builder);
        this.checks = builder.checks;
    }

    public final boolean hasChecks() {
        return this.checks != null && !(this.checks instanceof SdkAutoConstructList);
    }

    public final List<TrustedAdvisorCheckDescription> checks() {
        return this.checks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChecks() ? this.checks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorChecksResponse)) {
            return false;
        }
        DescribeTrustedAdvisorChecksResponse other = (DescribeTrustedAdvisorChecksResponse)((Object)obj);
        return this.hasChecks() == other.hasChecks() && Objects.equals(this.checks(), other.checks());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorChecksResponse").add("Checks", this.hasChecks() ? this.checks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checks": {
                return Optional.ofNullable(clazz.cast(this.checks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TrustedAdvisorCheckDescription>>> map = new HashMap<String, SdkField<List<TrustedAdvisorCheckDescription>>>();
        map.put("checks", CHECKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorChecksResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorChecksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<TrustedAdvisorCheckDescription> checks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorChecksResponse model) {
            super(model);
            this.checks(model.checks);
        }

        public final List<TrustedAdvisorCheckDescription.Builder> getChecks() {
            List<TrustedAdvisorCheckDescription.Builder> result = TrustedAdvisorCheckListCopier.copyToBuilder(this.checks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChecks(Collection<TrustedAdvisorCheckDescription.BuilderImpl> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copyFromBuilder(checks);
        }

        @Override
        public final Builder checks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(TrustedAdvisorCheckDescription ... checks) {
            this.checks(Arrays.asList(checks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder> ... checks) {
            this.checks(Stream.of(checks).map(c -> (TrustedAdvisorCheckDescription)((TrustedAdvisorCheckDescription.Builder)TrustedAdvisorCheckDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrustedAdvisorChecksResponse build() {
            return new DescribeTrustedAdvisorChecksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
        public Builder checks(Collection<TrustedAdvisorCheckDescription> var1);

        public Builder checks(TrustedAdvisorCheckDescription ... var1);

        public Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder> ... var1);
    }
}

