/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedAdvisorCheckSummariesRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
    private static final SdkField<List<String>> CHECK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("checkIds").getter(DescribeTrustedAdvisorCheckSummariesRequest.getter(DescribeTrustedAdvisorCheckSummariesRequest::checkIds)).setter(DescribeTrustedAdvisorCheckSummariesRequest.setter(Builder::checkIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("checkIds", CHECK_IDS_FIELD);
        }
    });
    private final List<String> checkIds;

    private DescribeTrustedAdvisorCheckSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.checkIds = builder.checkIds;
    }

    public final boolean hasCheckIds() {
        return this.checkIds != null && !(this.checkIds instanceof SdkAutoConstructList);
    }

    public final List<String> checkIds() {
        return this.checkIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckIds() ? this.checkIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesRequest other = (DescribeTrustedAdvisorCheckSummariesRequest)((Object)obj);
        return this.hasCheckIds() == other.hasCheckIds() && Objects.equals(this.checkIds(), other.checkIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorCheckSummariesRequest").add("CheckIds", this.hasCheckIds() ? this.checkIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkIds": {
                return Optional.ofNullable(clazz.cast(this.checkIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckSummariesRequest, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private List<String> checkIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesRequest model) {
            super(model);
            this.checkIds(model.checkIds);
        }

        public final Collection<String> getCheckIds() {
            if (this.checkIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.checkIds;
        }

        public final void setCheckIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
        }

        @Override
        public final Builder checkIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIds(String ... checkIds) {
            this.checkIds(Arrays.asList(checkIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesRequest build() {
            return new DescribeTrustedAdvisorCheckSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
        public Builder checkIds(Collection<String> var1);

        public Builder checkIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

