/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.internal.UserAgentUtils;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;

public class DescribeCommunicationsIterable
implements SdkIterable<DescribeCommunicationsResponse> {
    private final SupportClient client;
    private final DescribeCommunicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCommunicationsIterable(SupportClient client, DescribeCommunicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCommunicationsResponseFetcher();
    }

    public Iterator<DescribeCommunicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Communication> communications() {
        Function<DescribeCommunicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.communications() != null) {
                return response.communications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCommunicationsResponseFetcher
    implements SyncPageFetcher<DescribeCommunicationsResponse> {
        private DescribeCommunicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCommunicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCommunicationsResponse nextPage(DescribeCommunicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCommunicationsIterable.this.client.describeCommunications(DescribeCommunicationsIterable.this.firstRequest);
            }
            return DescribeCommunicationsIterable.this.client.describeCommunications((DescribeCommunicationsRequest)((Object)DescribeCommunicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

