/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.support.DefaultSupportBaseClientBuilder;
import software.amazon.awssdk.services.support.DefaultSupportClient;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.SupportClientBuilder;
import software.amazon.awssdk.services.support.SupportServiceClientConfiguration;
import software.amazon.awssdk.services.support.endpoints.SupportEndpointProvider;

@SdkInternalApi
final class DefaultSupportClientBuilder
extends DefaultSupportBaseClientBuilder<SupportClientBuilder, SupportClient>
implements SupportClientBuilder {
    DefaultSupportClientBuilder() {
    }

    @Override
    public DefaultSupportClientBuilder endpointProvider(SupportEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SupportClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSupportClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SupportServiceClientConfiguration serviceClientConfiguration = SupportServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSupportClient(serviceClientConfiguration, clientConfiguration);
    }
}

