/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.support.endpoints.SupportEndpointParams;
import software.amazon.awssdk.services.support.endpoints.SupportEndpointProvider;
import software.amazon.awssdk.services.support.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.support.endpoints.internal.Condition;
import software.amazon.awssdk.services.support.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.support.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.support.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.support.endpoints.internal.Expr;
import software.amazon.awssdk.services.support.endpoints.internal.FnNode;
import software.amazon.awssdk.services.support.endpoints.internal.Identifier;
import software.amazon.awssdk.services.support.endpoints.internal.Literal;
import software.amazon.awssdk.services.support.endpoints.internal.Parameter;
import software.amazon.awssdk.services.support.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.support.endpoints.internal.Parameters;
import software.amazon.awssdk.services.support.endpoints.internal.Rule;
import software.amazon.awssdk.services.support.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultSupportEndpointProvider
implements SupportEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultSupportEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(SupportEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultSupportEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(SupportEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_3() {
        return Rule.builder().treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_4(), DefaultSupportEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_2(), DefaultSupportEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_8(), DefaultSupportEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_12(), DefaultSupportEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_16(), DefaultSupportEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_7(), DefaultSupportEndpointProvider.endpointRule_11(), DefaultSupportEndpointProvider.endpointRule_15(), DefaultSupportEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_22() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_22(), DefaultSupportEndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_26(), DefaultSupportEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_31() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_31()));
    }

    private static Rule endpointRule_32() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_30(), DefaultSupportEndpointProvider.endpointRule_32()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.cn-north-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-north-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_21(), DefaultSupportEndpointProvider.endpointRule_25(), DefaultSupportEndpointProvider.endpointRule_29(), DefaultSupportEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_37() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_36() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_37()));
    }

    private static Rule endpointRule_38() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_35() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_36(), DefaultSupportEndpointProvider.endpointRule_38()));
    }

    private static Rule endpointRule_41() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_40() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_41()));
    }

    private static Rule endpointRule_42() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_39() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_40(), DefaultSupportEndpointProvider.endpointRule_42()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_45()));
    }

    private static Rule endpointRule_46() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_43() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_44(), DefaultSupportEndpointProvider.endpointRule_46()));
    }

    private static Rule endpointRule_47() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.us-gov-west-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-gov-west-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_34() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_35(), DefaultSupportEndpointProvider.endpointRule_39(), DefaultSupportEndpointProvider.endpointRule_43(), DefaultSupportEndpointProvider.endpointRule_47()));
    }

    private static Rule endpointRule_51() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.c2s.ic.gov")).build());
    }

    private static Rule endpointRule_50() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_51()));
    }

    private static Rule endpointRule_52() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_49() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_50(), DefaultSupportEndpointProvider.endpointRule_52()));
    }

    private static Rule endpointRule_53() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.us-iso-east-1.c2s.ic.gov")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-iso-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-iso"))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_49(), DefaultSupportEndpointProvider.endpointRule_53()));
    }

    private static Rule endpointRule_57() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.sc2s.sgov.gov")).build());
    }

    private static Rule endpointRule_56() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_57()));
    }

    private static Rule endpointRule_58() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_55() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_56(), DefaultSupportEndpointProvider.endpointRule_58()));
    }

    private static Rule endpointRule_59() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.us-isob-east-1.sc2s.sgov.gov")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-isob-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_54() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-iso-b"))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_55(), DefaultSupportEndpointProvider.endpointRule_59()));
    }

    private static Rule endpointRule_63() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_62() {
        return Rule.builder().treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_63()));
    }

    private static Rule endpointRule_61() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_62()));
    }

    private static Rule endpointRule_64() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_60() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_61(), DefaultSupportEndpointProvider.endpointRule_64()));
    }

    private static Rule endpointRule_68() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_67() {
        return Rule.builder().treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_68()));
    }

    private static Rule endpointRule_66() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_67()));
    }

    private static Rule endpointRule_69() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_65() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_66(), DefaultSupportEndpointProvider.endpointRule_69()));
    }

    private static Rule endpointRule_73() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_72() {
        return Rule.builder().treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_73()));
    }

    private static Rule endpointRule_71() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_72()));
    }

    private static Rule endpointRule_74() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_70() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_71(), DefaultSupportEndpointProvider.endpointRule_74()));
    }

    private static Rule endpointRule_76() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://support.us-east-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_77() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-cn-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://support.cn-north-1.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-north-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_78() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-us-gov-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://support.us-gov-west-1.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-gov-west-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_79() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-iso-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://support.us-iso-east-1.c2s.ic.gov")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-iso-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_80() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-iso-b-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://support.us-isob-east-1.sc2s.sgov.gov")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-isob-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("support")))))).build());
    }

    private static Rule endpointRule_81() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://support.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_75() {
        return Rule.builder().treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_76(), DefaultSupportEndpointProvider.endpointRule_77(), DefaultSupportEndpointProvider.endpointRule_78(), DefaultSupportEndpointProvider.endpointRule_79(), DefaultSupportEndpointProvider.endpointRule_80(), DefaultSupportEndpointProvider.endpointRule_81()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultSupportEndpointProvider.endpointRule_1(), DefaultSupportEndpointProvider.endpointRule_6(), DefaultSupportEndpointProvider.endpointRule_20(), DefaultSupportEndpointProvider.endpointRule_34(), DefaultSupportEndpointProvider.endpointRule_48(), DefaultSupportEndpointProvider.endpointRule_54(), DefaultSupportEndpointProvider.endpointRule_60(), DefaultSupportEndpointProvider.endpointRule_65(), DefaultSupportEndpointProvider.endpointRule_70(), DefaultSupportEndpointProvider.endpointRule_75()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(true).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultSupportEndpointProvider.endpointRule_0()).build();
    }
}

