/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about AWS resources that were analyzed in a call to Trusted Advisor
 * <a>DescribeTrustedAdvisorCheckSummaries</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedAdvisorResourcesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedAdvisorResourcesSummary.Builder, TrustedAdvisorResourcesSummary> {
    private static final SdkField<Long> RESOURCES_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TrustedAdvisorResourcesSummary::resourcesProcessed)).setter(setter(Builder::resourcesProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesProcessed").build())
            .build();

    private static final SdkField<Long> RESOURCES_FLAGGED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TrustedAdvisorResourcesSummary::resourcesFlagged)).setter(setter(Builder::resourcesFlagged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesFlagged").build()).build();

    private static final SdkField<Long> RESOURCES_IGNORED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TrustedAdvisorResourcesSummary::resourcesIgnored)).setter(setter(Builder::resourcesIgnored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesIgnored").build()).build();

    private static final SdkField<Long> RESOURCES_SUPPRESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TrustedAdvisorResourcesSummary::resourcesSuppressed)).setter(setter(Builder::resourcesSuppressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSuppressed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_PROCESSED_FIELD,
            RESOURCES_FLAGGED_FIELD, RESOURCES_IGNORED_FIELD, RESOURCES_SUPPRESSED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long resourcesProcessed;

    private final Long resourcesFlagged;

    private final Long resourcesIgnored;

    private final Long resourcesSuppressed;

    private TrustedAdvisorResourcesSummary(BuilderImpl builder) {
        this.resourcesProcessed = builder.resourcesProcessed;
        this.resourcesFlagged = builder.resourcesFlagged;
        this.resourcesIgnored = builder.resourcesIgnored;
        this.resourcesSuppressed = builder.resourcesSuppressed;
    }

    /**
     * <p>
     * The number of AWS resources that were analyzed by the Trusted Advisor check.
     * </p>
     * 
     * @return The number of AWS resources that were analyzed by the Trusted Advisor check.
     */
    public Long resourcesProcessed() {
        return resourcesProcessed;
    }

    /**
     * <p>
     * The number of AWS resources that were flagged (listed) by the Trusted Advisor check.
     * </p>
     * 
     * @return The number of AWS resources that were flagged (listed) by the Trusted Advisor check.
     */
    public Long resourcesFlagged() {
        return resourcesFlagged;
    }

    /**
     * <p>
     * The number of AWS resources ignored by Trusted Advisor because information was unavailable.
     * </p>
     * 
     * @return The number of AWS resources ignored by Trusted Advisor because information was unavailable.
     */
    public Long resourcesIgnored() {
        return resourcesIgnored;
    }

    /**
     * <p>
     * The number of AWS resources ignored by Trusted Advisor because they were marked as suppressed by the user.
     * </p>
     * 
     * @return The number of AWS resources ignored by Trusted Advisor because they were marked as suppressed by the
     *         user.
     */
    public Long resourcesSuppressed() {
        return resourcesSuppressed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourcesProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesFlagged());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesIgnored());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSuppressed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourcesSummary)) {
            return false;
        }
        TrustedAdvisorResourcesSummary other = (TrustedAdvisorResourcesSummary) obj;
        return Objects.equals(resourcesProcessed(), other.resourcesProcessed())
                && Objects.equals(resourcesFlagged(), other.resourcesFlagged())
                && Objects.equals(resourcesIgnored(), other.resourcesIgnored())
                && Objects.equals(resourcesSuppressed(), other.resourcesSuppressed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorResourcesSummary").add("ResourcesProcessed", resourcesProcessed())
                .add("ResourcesFlagged", resourcesFlagged()).add("ResourcesIgnored", resourcesIgnored())
                .add("ResourcesSuppressed", resourcesSuppressed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourcesProcessed":
            return Optional.ofNullable(clazz.cast(resourcesProcessed()));
        case "resourcesFlagged":
            return Optional.ofNullable(clazz.cast(resourcesFlagged()));
        case "resourcesIgnored":
            return Optional.ofNullable(clazz.cast(resourcesIgnored()));
        case "resourcesSuppressed":
            return Optional.ofNullable(clazz.cast(resourcesSuppressed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorResourcesSummary, T> g) {
        return obj -> g.apply((TrustedAdvisorResourcesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedAdvisorResourcesSummary> {
        /**
         * <p>
         * The number of AWS resources that were analyzed by the Trusted Advisor check.
         * </p>
         * 
         * @param resourcesProcessed
         *        The number of AWS resources that were analyzed by the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesProcessed(Long resourcesProcessed);

        /**
         * <p>
         * The number of AWS resources that were flagged (listed) by the Trusted Advisor check.
         * </p>
         * 
         * @param resourcesFlagged
         *        The number of AWS resources that were flagged (listed) by the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesFlagged(Long resourcesFlagged);

        /**
         * <p>
         * The number of AWS resources ignored by Trusted Advisor because information was unavailable.
         * </p>
         * 
         * @param resourcesIgnored
         *        The number of AWS resources ignored by Trusted Advisor because information was unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesIgnored(Long resourcesIgnored);

        /**
         * <p>
         * The number of AWS resources ignored by Trusted Advisor because they were marked as suppressed by the user.
         * </p>
         * 
         * @param resourcesSuppressed
         *        The number of AWS resources ignored by Trusted Advisor because they were marked as suppressed by the
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSuppressed(Long resourcesSuppressed);
    }

    static final class BuilderImpl implements Builder {
        private Long resourcesProcessed;

        private Long resourcesFlagged;

        private Long resourcesIgnored;

        private Long resourcesSuppressed;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourcesSummary model) {
            resourcesProcessed(model.resourcesProcessed);
            resourcesFlagged(model.resourcesFlagged);
            resourcesIgnored(model.resourcesIgnored);
            resourcesSuppressed(model.resourcesSuppressed);
        }

        public final Long getResourcesProcessed() {
            return resourcesProcessed;
        }

        @Override
        public final Builder resourcesProcessed(Long resourcesProcessed) {
            this.resourcesProcessed = resourcesProcessed;
            return this;
        }

        public final void setResourcesProcessed(Long resourcesProcessed) {
            this.resourcesProcessed = resourcesProcessed;
        }

        public final Long getResourcesFlagged() {
            return resourcesFlagged;
        }

        @Override
        public final Builder resourcesFlagged(Long resourcesFlagged) {
            this.resourcesFlagged = resourcesFlagged;
            return this;
        }

        public final void setResourcesFlagged(Long resourcesFlagged) {
            this.resourcesFlagged = resourcesFlagged;
        }

        public final Long getResourcesIgnored() {
            return resourcesIgnored;
        }

        @Override
        public final Builder resourcesIgnored(Long resourcesIgnored) {
            this.resourcesIgnored = resourcesIgnored;
            return this;
        }

        public final void setResourcesIgnored(Long resourcesIgnored) {
            this.resourcesIgnored = resourcesIgnored;
        }

        public final Long getResourcesSuppressed() {
            return resourcesSuppressed;
        }

        @Override
        public final Builder resourcesSuppressed(Long resourcesSuppressed) {
            this.resourcesSuppressed = resourcesSuppressed;
            return this;
        }

        public final void setResourcesSuppressed(Long resourcesSuppressed) {
            this.resourcesSuppressed = resourcesSuppressed;
        }

        @Override
        public TrustedAdvisorResourcesSummary build() {
            return new TrustedAdvisorResourcesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
