/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorChecks</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedAdvisorChecksResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeTrustedAdvisorChecksResponse.Builder, DescribeTrustedAdvisorChecksResponse> {
    private static final SdkField<List<TrustedAdvisorCheckDescription>> CHECKS_FIELD = SdkField
            .<List<TrustedAdvisorCheckDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrustedAdvisorChecksResponse::checks))
            .setter(setter(Builder::checks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustedAdvisorCheckDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustedAdvisorCheckDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKS_FIELD));

    private final List<TrustedAdvisorCheckDescription> checks;

    private DescribeTrustedAdvisorChecksResponse(BuilderImpl builder) {
        super(builder);
        this.checks = builder.checks;
    }

    /**
     * Returns true if the Checks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChecks() {
        return checks != null && !(checks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about all available Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChecks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about all available Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckDescription> checks() {
        return checks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorChecksResponse)) {
            return false;
        }
        DescribeTrustedAdvisorChecksResponse other = (DescribeTrustedAdvisorChecksResponse) obj;
        return Objects.equals(checks(), other.checks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrustedAdvisorChecksResponse").add("Checks", checks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checks":
            return Optional.ofNullable(clazz.cast(checks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorChecksResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorChecksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedAdvisorChecksResponse> {
        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(Collection<TrustedAdvisorCheckDescription> checks);

        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * 
         * @param checks
         *        Information about all available Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checks(TrustedAdvisorCheckDescription... checks);

        /**
         * <p>
         * Information about all available Trusted Advisor checks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrustedAdvisorCheckDescription>.Builder}
         * avoiding the need to create one manually via {@link List<TrustedAdvisorCheckDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrustedAdvisorCheckDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #checks(List<TrustedAdvisorCheckDescription>)}.
         * 
         * @param checks
         *        a consumer that will call methods on {@link List<TrustedAdvisorCheckDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checks(List<TrustedAdvisorCheckDescription>)
         */
        Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder>... checks);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckDescription> checks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorChecksResponse model) {
            super(model);
            checks(model.checks);
        }

        public final Collection<TrustedAdvisorCheckDescription.Builder> getChecks() {
            return checks != null ? checks.stream().map(TrustedAdvisorCheckDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder checks(Collection<TrustedAdvisorCheckDescription> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copy(checks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(TrustedAdvisorCheckDescription... checks) {
            checks(Arrays.asList(checks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checks(Consumer<TrustedAdvisorCheckDescription.Builder>... checks) {
            checks(Stream.of(checks).map(c -> TrustedAdvisorCheckDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChecks(Collection<TrustedAdvisorCheckDescription.BuilderImpl> checks) {
            this.checks = TrustedAdvisorCheckListCopier.copyFromBuilder(checks);
        }

        @Override
        public DescribeTrustedAdvisorChecksResponse build() {
            return new DescribeTrustedAdvisorChecksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
