/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns an array of <a>CaseDetails</a> objects and a <code>nextToken</code> that defines a point for pagination in
 * the result set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCasesResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeCasesResponse.Builder, DescribeCasesResponse> {
    private static final SdkField<List<CaseDetails>> CASES_FIELD = SdkField
            .<List<CaseDetails>> builder(MarshallingType.LIST)
            .getter(getter(DescribeCasesResponse::cases))
            .setter(setter(Builder::cases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CASES_FIELD, NEXT_TOKEN_FIELD));

    private final List<CaseDetails> cases;

    private final String nextToken;

    private DescribeCasesResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Cases property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCases() {
        return cases != null && !(cases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the cases that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details for the cases that match the request.
     */
    public List<CaseDetails> cases() {
        return cases;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesResponse)) {
            return false;
        }
        DescribeCasesResponse other = (DescribeCasesResponse) obj;
        return Objects.equals(cases(), other.cases()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCasesResponse").add("Cases", cases()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cases":
            return Optional.ofNullable(clazz.cast(cases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCasesResponse, T> g) {
        return obj -> g.apply((DescribeCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCasesResponse> {
        /**
         * <p>
         * The details for the cases that match the request.
         * </p>
         * 
         * @param cases
         *        The details for the cases that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(Collection<CaseDetails> cases);

        /**
         * <p>
         * The details for the cases that match the request.
         * </p>
         * 
         * @param cases
         *        The details for the cases that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(CaseDetails... cases);

        /**
         * <p>
         * The details for the cases that match the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CaseDetails>.Builder} avoiding the need to
         * create one manually via {@link List<CaseDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CaseDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #cases(List<CaseDetails>)}.
         * 
         * @param cases
         *        a consumer that will call methods on {@link List<CaseDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cases(List<CaseDetails>)
         */
        Builder cases(Consumer<CaseDetails.Builder>... cases);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<CaseDetails> cases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesResponse model) {
            super(model);
            cases(model.cases);
            nextToken(model.nextToken);
        }

        public final Collection<CaseDetails.Builder> getCases() {
            return cases != null ? cases.stream().map(CaseDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseDetails... cases) {
            cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<CaseDetails.Builder>... cases) {
            cases(Stream.of(cases).map(c -> CaseDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCases(Collection<CaseDetails.BuilderImpl> cases) {
            this.cases = CaseListCopier.copyFromBuilder(cases);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCasesResponse build() {
            return new DescribeCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
