/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCategorySpecificSummary;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourcesSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustedAdvisorCheckSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::checkId)).setter(TrustedAdvisorCheckSummary.setter(Builder::checkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::timestamp)).setter(TrustedAdvisorCheckSummary.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::status)).setter(TrustedAdvisorCheckSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> HAS_FLAGGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::hasFlaggedResources)).setter(TrustedAdvisorCheckSummary.setter(Builder::hasFlaggedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasFlaggedResources").build()}).build();
    private static final SdkField<TrustedAdvisorResourcesSummary> RESOURCES_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::resourcesSummary)).setter(TrustedAdvisorCheckSummary.setter(Builder::resourcesSummary)).constructor(TrustedAdvisorResourcesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSummary").build()}).build();
    private static final SdkField<TrustedAdvisorCategorySpecificSummary> CATEGORY_SPECIFIC_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrustedAdvisorCheckSummary.getter(TrustedAdvisorCheckSummary::categorySpecificSummary)).setter(TrustedAdvisorCheckSummary.setter(Builder::categorySpecificSummary)).constructor(TrustedAdvisorCategorySpecificSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorySpecificSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_ID_FIELD, TIMESTAMP_FIELD, STATUS_FIELD, HAS_FLAGGED_RESOURCES_FIELD, RESOURCES_SUMMARY_FIELD, CATEGORY_SPECIFIC_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String checkId;
    private final String timestamp;
    private final String status;
    private final Boolean hasFlaggedResources;
    private final TrustedAdvisorResourcesSummary resourcesSummary;
    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private TrustedAdvisorCheckSummary(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.hasFlaggedResources = builder.hasFlaggedResources;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    public String checkId() {
        return this.checkId;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public String status() {
        return this.status;
    }

    public Boolean hasFlaggedResources() {
        return this.hasFlaggedResources;
    }

    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return this.resourcesSummary;
    }

    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return this.categorySpecificSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.categorySpecificSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckSummary)) {
            return false;
        }
        TrustedAdvisorCheckSummary other = (TrustedAdvisorCheckSummary)obj;
        return Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.hasFlaggedResources(), other.hasFlaggedResources()) && Objects.equals(this.resourcesSummary(), other.resourcesSummary()) && Objects.equals(this.categorySpecificSummary(), other.categorySpecificSummary());
    }

    public String toString() {
        return ToString.builder((String)"TrustedAdvisorCheckSummary").add("CheckId", (Object)this.checkId()).add("Timestamp", (Object)this.timestamp()).add("Status", (Object)this.status()).add("HasFlaggedResources", (Object)this.hasFlaggedResources()).add("ResourcesSummary", (Object)this.resourcesSummary()).add("CategorySpecificSummary", (Object)this.categorySpecificSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkId": {
                return Optional.ofNullable(clazz.cast(this.checkId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "hasFlaggedResources": {
                return Optional.ofNullable(clazz.cast(this.hasFlaggedResources()));
            }
            case "resourcesSummary": {
                return Optional.ofNullable(clazz.cast(this.resourcesSummary()));
            }
            case "categorySpecificSummary": {
                return Optional.ofNullable(clazz.cast(this.categorySpecificSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckSummary, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkId;
        private String timestamp;
        private String status;
        private Boolean hasFlaggedResources;
        private TrustedAdvisorResourcesSummary resourcesSummary;
        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckSummary model) {
            this.checkId(model.checkId);
            this.timestamp(model.timestamp);
            this.status(model.status);
            this.hasFlaggedResources(model.hasFlaggedResources);
            this.resourcesSummary(model.resourcesSummary);
            this.categorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getCheckId() {
            return this.checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getHasFlaggedResources() {
            return this.hasFlaggedResources;
        }

        @Override
        public final Builder hasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
            return this;
        }

        public final void setHasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return this.resourcesSummary != null ? this.resourcesSummary.toBuilder() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return this.categorySpecificSummary != null ? this.categorySpecificSummary.toBuilder() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        public TrustedAdvisorCheckSummary build() {
            return new TrustedAdvisorCheckSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
        public Builder checkId(String var1);

        public Builder timestamp(String var1);

        public Builder status(String var1);

        public Builder hasFlaggedResources(Boolean var1);

        public Builder resourcesSummary(TrustedAdvisorResourcesSummary var1);

        default public Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return this.resourcesSummary((TrustedAdvisorResourcesSummary)((TrustedAdvisorResourcesSummary.Builder)TrustedAdvisorResourcesSummary.builder().applyMutation(resourcesSummary)).build());
        }

        public Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary var1);

        default public Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return this.categorySpecificSummary((TrustedAdvisorCategorySpecificSummary)((TrustedAdvisorCategorySpecificSummary.Builder)TrustedAdvisorCategorySpecificSummary.builder().applyMutation(categorySpecificSummary)).build());
        }
    }
}

