/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckRefreshStatus;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckRefreshStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedAdvisorCheckRefreshStatusesResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
    private static final SdkField<List<TrustedAdvisorCheckRefreshStatus>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTrustedAdvisorCheckRefreshStatusesResponse.getter(DescribeTrustedAdvisorCheckRefreshStatusesResponse::statuses)).setter(DescribeTrustedAdvisorCheckRefreshStatusesResponse.setter(Builder::statuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedAdvisorCheckRefreshStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUSES_FIELD));
    private final List<TrustedAdvisorCheckRefreshStatus> statuses;

    private DescribeTrustedAdvisorCheckRefreshStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.statuses = builder.statuses;
    }

    public List<TrustedAdvisorCheckRefreshStatus> statuses() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckRefreshStatusesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckRefreshStatusesResponse other = (DescribeTrustedAdvisorCheckRefreshStatusesResponse)((Object)obj);
        return Objects.equals(this.statuses(), other.statuses());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorCheckRefreshStatusesResponse").add("Statuses", this.statuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statuses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckRefreshStatusesResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckRefreshStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<TrustedAdvisorCheckRefreshStatus> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckRefreshStatusesResponse model) {
            super(model);
            this.statuses(model.statuses);
        }

        public final Collection<TrustedAdvisorCheckRefreshStatus.Builder> getStatuses() {
            return this.statuses != null ? (Collection)this.statuses.stream().map(TrustedAdvisorCheckRefreshStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(TrustedAdvisorCheckRefreshStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<TrustedAdvisorCheckRefreshStatus.Builder> ... statuses) {
            this.statuses(Stream.of(statuses).map(c -> (TrustedAdvisorCheckRefreshStatus)((TrustedAdvisorCheckRefreshStatus.Builder)TrustedAdvisorCheckRefreshStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<TrustedAdvisorCheckRefreshStatus.BuilderImpl> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeTrustedAdvisorCheckRefreshStatusesResponse build() {
            return new DescribeTrustedAdvisorCheckRefreshStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
        public Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> var1);

        public Builder statuses(TrustedAdvisorCheckRefreshStatus ... var1);

        public Builder statuses(Consumer<TrustedAdvisorCheckRefreshStatus.Builder> ... var1);
    }
}

