/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.support.SupportAsyncClient;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;

public class DescribeCasesPublisher
implements SdkPublisher<DescribeCasesResponse> {
    private final SupportAsyncClient client;
    private final DescribeCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCasesPublisher(SupportAsyncClient client, DescribeCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCasesPublisher(SupportAsyncClient client, DescribeCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<CaseDetails> cases() {
        Function<DescribeCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cases() != null) {
                return response.cases().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeCasesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeCasesPublisher resume(DescribeCasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCasesPublisher(this.client, (DescribeCasesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeCasesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCasesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCasesResponseFetcher
    implements AsyncPageFetcher<DescribeCasesResponse> {
        private DescribeCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCasesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeCasesResponse> nextPage(DescribeCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCasesPublisher.this.client.describeCases(DescribeCasesPublisher.this.firstRequest);
            }
            return DescribeCasesPublisher.this.client.describeCases((DescribeCasesRequest)((Object)DescribeCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

