/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.support.model.Service;
import software.amazon.awssdk.services.support.model.ServiceListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServicesResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeServicesResponse> {
    private final List<Service> services;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
    }

    public List<Service> services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse)((Object)obj);
        return Objects.equals(this.services(), other.services());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServicesResponse").add("Services", this.services()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "services": {
                return Optional.of(clazz.cast(this.services()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<Service> services;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            this.services(model.services);
        }

        public final Collection<Service.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    CopyableBuilder<Builder, DescribeServicesResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);
    }
}

