/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCaseRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCaseRequest> {
    private final String subject;
    private final String serviceCode;
    private final String severityCode;
    private final String categoryCode;
    private final String communicationBody;
    private final List<String> ccEmailAddresses;
    private final String language;
    private final String issueType;
    private final String attachmentSetId;

    private CreateCaseRequest(BuilderImpl builder) {
        this.subject = builder.subject;
        this.serviceCode = builder.serviceCode;
        this.severityCode = builder.severityCode;
        this.categoryCode = builder.categoryCode;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
        this.issueType = builder.issueType;
        this.attachmentSetId = builder.attachmentSetId;
    }

    public String subject() {
        return this.subject;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public String severityCode() {
        return this.severityCode;
    }

    public String categoryCode() {
        return this.categoryCode;
    }

    public String communicationBody() {
        return this.communicationBody;
    }

    public List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public String language() {
        return this.language;
    }

    public String issueType() {
        return this.issueType;
    }

    public String attachmentSetId() {
        return this.attachmentSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.serviceCode() == null ? 0 : this.serviceCode().hashCode());
        hashCode = 31 * hashCode + (this.severityCode() == null ? 0 : this.severityCode().hashCode());
        hashCode = 31 * hashCode + (this.categoryCode() == null ? 0 : this.categoryCode().hashCode());
        hashCode = 31 * hashCode + (this.communicationBody() == null ? 0 : this.communicationBody().hashCode());
        hashCode = 31 * hashCode + (this.ccEmailAddresses() == null ? 0 : this.ccEmailAddresses().hashCode());
        hashCode = 31 * hashCode + (this.language() == null ? 0 : this.language().hashCode());
        hashCode = 31 * hashCode + (this.issueType() == null ? 0 : this.issueType().hashCode());
        hashCode = 31 * hashCode + (this.attachmentSetId() == null ? 0 : this.attachmentSetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest)((Object)obj);
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.serviceCode() == null ^ this.serviceCode() == null) {
            return false;
        }
        if (other.serviceCode() != null && !other.serviceCode().equals(this.serviceCode())) {
            return false;
        }
        if (other.severityCode() == null ^ this.severityCode() == null) {
            return false;
        }
        if (other.severityCode() != null && !other.severityCode().equals(this.severityCode())) {
            return false;
        }
        if (other.categoryCode() == null ^ this.categoryCode() == null) {
            return false;
        }
        if (other.categoryCode() != null && !other.categoryCode().equals(this.categoryCode())) {
            return false;
        }
        if (other.communicationBody() == null ^ this.communicationBody() == null) {
            return false;
        }
        if (other.communicationBody() != null && !other.communicationBody().equals(this.communicationBody())) {
            return false;
        }
        if (other.ccEmailAddresses() == null ^ this.ccEmailAddresses() == null) {
            return false;
        }
        if (other.ccEmailAddresses() != null && !other.ccEmailAddresses().equals(this.ccEmailAddresses())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        if (other.issueType() == null ^ this.issueType() == null) {
            return false;
        }
        if (other.issueType() != null && !other.issueType().equals(this.issueType())) {
            return false;
        }
        if (other.attachmentSetId() == null ^ this.attachmentSetId() == null) {
            return false;
        }
        return other.attachmentSetId() == null || other.attachmentSetId().equals(this.attachmentSetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.serviceCode() != null) {
            sb.append("ServiceCode: ").append(this.serviceCode()).append(",");
        }
        if (this.severityCode() != null) {
            sb.append("SeverityCode: ").append(this.severityCode()).append(",");
        }
        if (this.categoryCode() != null) {
            sb.append("CategoryCode: ").append(this.categoryCode()).append(",");
        }
        if (this.communicationBody() != null) {
            sb.append("CommunicationBody: ").append(this.communicationBody()).append(",");
        }
        if (this.ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(this.ccEmailAddresses()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        if (this.issueType() != null) {
            sb.append("IssueType: ").append(this.issueType()).append(",");
        }
        if (this.attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(this.attachmentSetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String subject;
        private String serviceCode;
        private String severityCode;
        private String categoryCode;
        private String communicationBody;
        private List<String> ccEmailAddresses;
        private String language;
        private String issueType;
        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            this.setSubject(model.subject);
            this.setServiceCode(model.serviceCode);
            this.setSeverityCode(model.severityCode);
            this.setCategoryCode(model.categoryCode);
            this.setCommunicationBody(model.communicationBody);
            this.setCcEmailAddresses(model.ccEmailAddresses);
            this.setLanguage(model.language);
            this.setIssueType(model.issueType);
            this.setAttachmentSetId(model.attachmentSetId);
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getSeverityCode() {
            return this.severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getCategoryCode() {
            return this.categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getCommunicationBody() {
            return this.communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return this.ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @SafeVarargs
        public final void setCcEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final String getIssueType() {
            return this.issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public final String getAttachmentSetId() {
            return this.attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCaseRequest> {
        public Builder subject(String var1);

        public Builder serviceCode(String var1);

        public Builder severityCode(String var1);

        public Builder categoryCode(String var1);

        public Builder communicationBody(String var1);

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder language(String var1);

        public Builder issueType(String var1);

        public Builder attachmentSetId(String var1);
    }
}

