/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.support.transform.AttachmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Attachment
implements StructuredPojo,
ToCopyableBuilder<Builder, Attachment> {
    private final String fileName;
    private final ByteBuffer data;

    private Attachment(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.data = builder.data;
    }

    public String fileName() {
        return this.fileName;
    }

    public ByteBuffer data() {
        return this.data == null ? null : this.data.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fileName() == null ? 0 : this.fileName().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (other.fileName() == null ^ this.fileName() == null) {
            return false;
        }
        if (other.fileName() != null && !other.fileName().equals(this.fileName())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        return other.data() == null || other.data().equals(this.data());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fileName() != null) {
            sb.append("FileName: ").append(this.fileName()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fileName;
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.setFileName(model.fileName);
            this.setData(model.data);
        }

        public final String getFileName() {
            return this.fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Attachment> {
        public Builder fileName(String var1);

        public Builder data(ByteBuffer var1);
    }
}

