/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details to be updated for a trusted token issuer configuration. The structure and settings
 * that you can include depend on the type of the trusted token issuer being updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedTokenIssuerUpdateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedTokenIssuerUpdateConfiguration.Builder, TrustedTokenIssuerUpdateConfiguration> {
    private static final SdkField<OidcJwtUpdateConfiguration> OIDC_JWT_CONFIGURATION_FIELD = SdkField
            .<OidcJwtUpdateConfiguration> builder(MarshallingType.SDK_POJO).memberName("OidcJwtConfiguration")
            .getter(getter(TrustedTokenIssuerUpdateConfiguration::oidcJwtConfiguration))
            .setter(setter(Builder::oidcJwtConfiguration)).constructor(OidcJwtUpdateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcJwtConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OIDC_JWT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OidcJwtUpdateConfiguration oidcJwtConfiguration;

    private final Type type;

    private TrustedTokenIssuerUpdateConfiguration(BuilderImpl builder) {
        this.oidcJwtConfiguration = builder.oidcJwtConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect (OIDC)
     * with JSON web tokens (JWT).
     * </p>
     * 
     * @return A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect
     *         (OIDC) with JSON web tokens (JWT).
     */
    public final OidcJwtUpdateConfiguration oidcJwtConfiguration() {
        return oidcJwtConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oidcJwtConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedTokenIssuerUpdateConfiguration)) {
            return false;
        }
        TrustedTokenIssuerUpdateConfiguration other = (TrustedTokenIssuerUpdateConfiguration) obj;
        return Objects.equals(oidcJwtConfiguration(), other.oidcJwtConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedTokenIssuerUpdateConfiguration").add("OidcJwtConfiguration", oidcJwtConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OidcJwtConfiguration":
            return Optional.ofNullable(clazz.cast(oidcJwtConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #oidcJwtConfiguration()} initialized to the given value.
     *
     * <p>
     * A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect (OIDC)
     * with JSON web tokens (JWT).
     * </p>
     * 
     * @param oidcJwtConfiguration
     *        A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect
     *        (OIDC) with JSON web tokens (JWT).
     */
    public static TrustedTokenIssuerUpdateConfiguration fromOidcJwtConfiguration(OidcJwtUpdateConfiguration oidcJwtConfiguration) {
        return builder().oidcJwtConfiguration(oidcJwtConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #oidcJwtConfiguration()} initialized to the given value.
     *
     * <p>
     * A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect (OIDC)
     * with JSON web tokens (JWT).
     * </p>
     * 
     * @param oidcJwtConfiguration
     *        A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect
     *        (OIDC) with JSON web tokens (JWT).
     */
    public static TrustedTokenIssuerUpdateConfiguration fromOidcJwtConfiguration(
            Consumer<OidcJwtUpdateConfiguration.Builder> oidcJwtConfiguration) {
        OidcJwtUpdateConfiguration.Builder builder = OidcJwtUpdateConfiguration.builder();
        oidcJwtConfiguration.accept(builder);
        return fromOidcJwtConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OidcJwtConfiguration", OIDC_JWT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustedTokenIssuerUpdateConfiguration, T> g) {
        return obj -> g.apply((TrustedTokenIssuerUpdateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedTokenIssuerUpdateConfiguration> {
        /**
         * <p>
         * A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect
         * (OIDC) with JSON web tokens (JWT).
         * </p>
         * 
         * @param oidcJwtConfiguration
         *        A structure that describes an updated configuration for a trusted token issuer that uses OpenID
         *        Connect (OIDC) with JSON web tokens (JWT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcJwtConfiguration(OidcJwtUpdateConfiguration oidcJwtConfiguration);

        /**
         * <p>
         * A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect
         * (OIDC) with JSON web tokens (JWT).
         * </p>
         * This is a convenience method that creates an instance of the {@link OidcJwtUpdateConfiguration.Builder}
         * avoiding the need to create one manually via {@link OidcJwtUpdateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OidcJwtUpdateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #oidcJwtConfiguration(OidcJwtUpdateConfiguration)}.
         * 
         * @param oidcJwtConfiguration
         *        a consumer that will call methods on {@link OidcJwtUpdateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcJwtConfiguration(OidcJwtUpdateConfiguration)
         */
        default Builder oidcJwtConfiguration(Consumer<OidcJwtUpdateConfiguration.Builder> oidcJwtConfiguration) {
            return oidcJwtConfiguration(OidcJwtUpdateConfiguration.builder().applyMutation(oidcJwtConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OidcJwtUpdateConfiguration oidcJwtConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedTokenIssuerUpdateConfiguration model) {
            oidcJwtConfiguration(model.oidcJwtConfiguration);
        }

        public final OidcJwtUpdateConfiguration.Builder getOidcJwtConfiguration() {
            return oidcJwtConfiguration != null ? oidcJwtConfiguration.toBuilder() : null;
        }

        public final void setOidcJwtConfiguration(OidcJwtUpdateConfiguration.BuilderImpl oidcJwtConfiguration) {
            Object oldValue = this.oidcJwtConfiguration;
            this.oidcJwtConfiguration = oidcJwtConfiguration != null ? oidcJwtConfiguration.build() : null;
            handleUnionValueChange(Type.OIDC_JWT_CONFIGURATION, oldValue, this.oidcJwtConfiguration);
        }

        @Override
        public final Builder oidcJwtConfiguration(OidcJwtUpdateConfiguration oidcJwtConfiguration) {
            Object oldValue = this.oidcJwtConfiguration;
            this.oidcJwtConfiguration = oidcJwtConfiguration;
            handleUnionValueChange(Type.OIDC_JWT_CONFIGURATION, oldValue, this.oidcJwtConfiguration);
            return this;
        }

        @Override
        public TrustedTokenIssuerUpdateConfiguration build() {
            return new TrustedTokenIssuerUpdateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TrustedTokenIssuerUpdateConfiguration#type()
     */
    public enum Type {
        OIDC_JWT_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
