/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the IAM Identity Center instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMetadata.Builder, InstanceMetadata> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(InstanceMetadata::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(InstanceMetadata::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(InstanceMetadata::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InstanceMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(InstanceMetadata::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InstanceMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(InstanceMetadata::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            IDENTITY_STORE_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, NAME_FIELD, CREATED_DATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceArn;

    private final String identityStoreId;

    private final String ownerAccountId;

    private final String name;

    private final Instant createdDate;

    private final String status;

    private final String statusReason;

    private InstanceMetadata(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.identityStoreId = builder.identityStoreId;
        this.ownerAccountId = builder.ownerAccountId;
        this.name = builder.name;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The ARN of the Identity Center instance under which the operation will be executed. For more information about
     * ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     * Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the Identity Center instance under which the operation will be executed. For more information
     *         about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     *         and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The identifier of the identity store that is connected to the Identity Center instance.
     * </p>
     * 
     * @return The identifier of the identity store that is connected to the Identity Center instance.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID number of the owner of the Identity Center instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID number of the owner of the Identity Center instance.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The name of the Identity Center instance.
     * </p>
     * 
     * @return The name of the Identity Center instance.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time that the Identity Center instance was created.
     * </p>
     * 
     * @return The date and time that the Identity Center instance was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The current status of this Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of this Identity Center instance.
     * @see InstanceStatus
     */
    public final InstanceStatus status() {
        return InstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of this Identity Center instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of this Identity Center instance.
     * @see InstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides additional context about the current status of the IAM Identity Center instance. This field is
     * particularly useful when an instance is in a non-ACTIVE state, such as CREATE_FAILED. When an instance creation
     * fails, this field contains information about the cause, which may include issues with KMS key configuration or
     * insufficient permissions.
     * </p>
     * 
     * @return Provides additional context about the current status of the IAM Identity Center instance. This field is
     *         particularly useful when an instance is in a non-ACTIVE state, such as CREATE_FAILED. When an instance
     *         creation fails, this field contains information about the cause, which may include issues with KMS key
     *         configuration or insufficient permissions.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadata)) {
            return false;
        }
        InstanceMetadata other = (InstanceMetadata) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(identityStoreId(), other.identityStoreId())
                && Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(name(), other.name())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMetadata").add("InstanceArn", instanceArn()).add("IdentityStoreId", identityStoreId())
                .add("OwnerAccountId", ownerAccountId()).add("Name", name()).add("CreatedDate", createdDate())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadata, T> g) {
        return obj -> g.apply((InstanceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMetadata> {
        /**
         * <p>
         * The ARN of the Identity Center instance under which the operation will be executed. For more information
         * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         * Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the Identity Center instance under which the operation will be executed. For more
         *        information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The identifier of the identity store that is connected to the Identity Center instance.
         * </p>
         * 
         * @param identityStoreId
         *        The identifier of the identity store that is connected to the Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The Amazon Web Services account ID number of the owner of the Identity Center instance.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID number of the owner of the Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The name of the Identity Center instance.
         * </p>
         * 
         * @param name
         *        The name of the Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time that the Identity Center instance was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the Identity Center instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The current status of this Identity Center instance.
         * </p>
         * 
         * @param status
         *        The current status of this Identity Center instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of this Identity Center instance.
         * </p>
         * 
         * @param status
         *        The current status of this Identity Center instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder status(InstanceStatus status);

        /**
         * <p>
         * Provides additional context about the current status of the IAM Identity Center instance. This field is
         * particularly useful when an instance is in a non-ACTIVE state, such as CREATE_FAILED. When an instance
         * creation fails, this field contains information about the cause, which may include issues with KMS key
         * configuration or insufficient permissions.
         * </p>
         * 
         * @param statusReason
         *        Provides additional context about the current status of the IAM Identity Center instance. This field
         *        is particularly useful when an instance is in a non-ACTIVE state, such as CREATE_FAILED. When an
         *        instance creation fails, this field contains information about the cause, which may include issues
         *        with KMS key configuration or insufficient permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String instanceArn;

        private String identityStoreId;

        private String ownerAccountId;

        private String name;

        private Instant createdDate;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadata model) {
            instanceArn(model.instanceArn);
            identityStoreId(model.identityStoreId);
            ownerAccountId(model.ownerAccountId);
            name(model.name);
            createdDate(model.createdDate);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public InstanceMetadata build() {
            return new InstanceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
