/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.JwksRetrievalOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OidcJwtUpdateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OidcJwtUpdateConfiguration> {
    private static final SdkField<String> CLAIM_ATTRIBUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClaimAttributePath").getter(OidcJwtUpdateConfiguration.getter(OidcJwtUpdateConfiguration::claimAttributePath)).setter(OidcJwtUpdateConfiguration.setter(Builder::claimAttributePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimAttributePath").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ATTRIBUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreAttributePath").getter(OidcJwtUpdateConfiguration.getter(OidcJwtUpdateConfiguration::identityStoreAttributePath)).setter(OidcJwtUpdateConfiguration.setter(Builder::identityStoreAttributePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreAttributePath").build()}).build();
    private static final SdkField<String> JWKS_RETRIEVAL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JwksRetrievalOption").getter(OidcJwtUpdateConfiguration.getter(OidcJwtUpdateConfiguration::jwksRetrievalOptionAsString)).setter(OidcJwtUpdateConfiguration.setter(Builder::jwksRetrievalOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksRetrievalOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_ATTRIBUTE_PATH_FIELD, IDENTITY_STORE_ATTRIBUTE_PATH_FIELD, JWKS_RETRIEVAL_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OidcJwtUpdateConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String claimAttributePath;
    private final String identityStoreAttributePath;
    private final String jwksRetrievalOption;

    private OidcJwtUpdateConfiguration(BuilderImpl builder) {
        this.claimAttributePath = builder.claimAttributePath;
        this.identityStoreAttributePath = builder.identityStoreAttributePath;
        this.jwksRetrievalOption = builder.jwksRetrievalOption;
    }

    public final String claimAttributePath() {
        return this.claimAttributePath;
    }

    public final String identityStoreAttributePath() {
        return this.identityStoreAttributePath;
    }

    public final JwksRetrievalOption jwksRetrievalOption() {
        return JwksRetrievalOption.fromValue(this.jwksRetrievalOption);
    }

    public final String jwksRetrievalOptionAsString() {
        return this.jwksRetrievalOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.claimAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwksRetrievalOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcJwtUpdateConfiguration)) {
            return false;
        }
        OidcJwtUpdateConfiguration other = (OidcJwtUpdateConfiguration)obj;
        return Objects.equals(this.claimAttributePath(), other.claimAttributePath()) && Objects.equals(this.identityStoreAttributePath(), other.identityStoreAttributePath()) && Objects.equals(this.jwksRetrievalOptionAsString(), other.jwksRetrievalOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OidcJwtUpdateConfiguration").add("ClaimAttributePath", (Object)this.claimAttributePath()).add("IdentityStoreAttributePath", (Object)this.identityStoreAttributePath()).add("JwksRetrievalOption", (Object)this.jwksRetrievalOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClaimAttributePath": {
                return Optional.ofNullable(clazz.cast(this.claimAttributePath()));
            }
            case "IdentityStoreAttributePath": {
                return Optional.ofNullable(clazz.cast(this.identityStoreAttributePath()));
            }
            case "JwksRetrievalOption": {
                return Optional.ofNullable(clazz.cast(this.jwksRetrievalOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClaimAttributePath", CLAIM_ATTRIBUTE_PATH_FIELD);
        map.put("IdentityStoreAttributePath", IDENTITY_STORE_ATTRIBUTE_PATH_FIELD);
        map.put("JwksRetrievalOption", JWKS_RETRIEVAL_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OidcJwtUpdateConfiguration, T> g) {
        return obj -> g.apply((OidcJwtUpdateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String claimAttributePath;
        private String identityStoreAttributePath;
        private String jwksRetrievalOption;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcJwtUpdateConfiguration model) {
            this.claimAttributePath(model.claimAttributePath);
            this.identityStoreAttributePath(model.identityStoreAttributePath);
            this.jwksRetrievalOption(model.jwksRetrievalOption);
        }

        public final String getClaimAttributePath() {
            return this.claimAttributePath;
        }

        public final void setClaimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
        }

        @Override
        public final Builder claimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
            return this;
        }

        public final String getIdentityStoreAttributePath() {
            return this.identityStoreAttributePath;
        }

        public final void setIdentityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
        }

        @Override
        public final Builder identityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
            return this;
        }

        public final String getJwksRetrievalOption() {
            return this.jwksRetrievalOption;
        }

        public final void setJwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
        }

        @Override
        public final Builder jwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
            return this;
        }

        @Override
        public final Builder jwksRetrievalOption(JwksRetrievalOption jwksRetrievalOption) {
            this.jwksRetrievalOption(jwksRetrievalOption == null ? null : jwksRetrievalOption.toString());
            return this;
        }

        public OidcJwtUpdateConfiguration build() {
            return new OidcJwtUpdateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OidcJwtUpdateConfiguration> {
        public Builder claimAttributePath(String var1);

        public Builder identityStoreAttributePath(String var1);

        public Builder jwksRetrievalOption(String var1);

        public Builder jwksRetrievalOption(JwksRetrievalOption var1);
    }
}

