/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ScopeTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScopeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScopeDetails> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ScopeDetails.getter(ScopeDetails::scope)).setter(ScopeDetails.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTargets").getter(ScopeDetails.getter(ScopeDetails::authorizedTargets)).setter(ScopeDetails.setter(Builder::authorizedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, AUTHORIZED_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScopeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final List<String> authorizedTargets;

    private ScopeDetails(BuilderImpl builder) {
        this.scope = builder.scope;
        this.authorizedTargets = builder.authorizedTargets;
    }

    public final String scope() {
        return this.scope;
    }

    public final boolean hasAuthorizedTargets() {
        return this.authorizedTargets != null && !(this.authorizedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedTargets() {
        return this.authorizedTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTargets() ? this.authorizedTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeDetails)) {
            return false;
        }
        ScopeDetails other = (ScopeDetails)obj;
        return Objects.equals(this.scope(), other.scope()) && this.hasAuthorizedTargets() == other.hasAuthorizedTargets() && Objects.equals(this.authorizedTargets(), other.authorizedTargets());
    }

    public final String toString() {
        return ToString.builder((String)"ScopeDetails").add("Scope", (Object)this.scope()).add("AuthorizedTargets", this.hasAuthorizedTargets() ? this.authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "AuthorizedTargets": {
                return Optional.ofNullable(clazz.cast(this.authorizedTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Scope", SCOPE_FIELD);
        map.put("AuthorizedTargets", AUTHORIZED_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScopeDetails, T> g) {
        return obj -> g.apply((ScopeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeDetails model) {
            this.scope(model.scope);
            this.authorizedTargets(model.authorizedTargets);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (this.authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String ... authorizedTargets) {
            this.authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        public ScopeDetails build() {
            return new ScopeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScopeDetails> {
        public Builder scope(String var1);

        public Builder authorizedTargets(Collection<String> var1);

        public Builder authorizedTargets(String ... var1);
    }
}

