/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationAuthenticationMethodRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, GetApplicationAuthenticationMethodRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(GetApplicationAuthenticationMethodRequest.getter(GetApplicationAuthenticationMethodRequest::applicationArn)).setter(GetApplicationAuthenticationMethodRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> AUTHENTICATION_METHOD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMethodType").getter(GetApplicationAuthenticationMethodRequest.getter(GetApplicationAuthenticationMethodRequest::authenticationMethodTypeAsString)).setter(GetApplicationAuthenticationMethodRequest.setter(Builder::authenticationMethodType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethodType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, AUTHENTICATION_METHOD_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationAuthenticationMethodRequest.memberNameToFieldInitializer();
    private final String applicationArn;
    private final String authenticationMethodType;

    private GetApplicationAuthenticationMethodRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.authenticationMethodType = builder.authenticationMethodType;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final AuthenticationMethodType authenticationMethodType() {
        return AuthenticationMethodType.fromValue(this.authenticationMethodType);
    }

    public final String authenticationMethodTypeAsString() {
        return this.authenticationMethodType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMethodTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationAuthenticationMethodRequest)) {
            return false;
        }
        GetApplicationAuthenticationMethodRequest other = (GetApplicationAuthenticationMethodRequest)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.authenticationMethodTypeAsString(), other.authenticationMethodTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationAuthenticationMethodRequest").add("ApplicationArn", (Object)this.applicationArn()).add("AuthenticationMethodType", (Object)this.authenticationMethodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "AuthenticationMethodType": {
                return Optional.ofNullable(clazz.cast(this.authenticationMethodTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("AuthenticationMethodType", AUTHENTICATION_METHOD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationAuthenticationMethodRequest, T> g) {
        return obj -> g.apply((GetApplicationAuthenticationMethodRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String authenticationMethodType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationAuthenticationMethodRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.authenticationMethodType(model.authenticationMethodType);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getAuthenticationMethodType() {
            return this.authenticationMethodType;
        }

        public final void setAuthenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
        }

        @Override
        public final Builder authenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
            return this;
        }

        @Override
        public final Builder authenticationMethodType(AuthenticationMethodType authenticationMethodType) {
            this.authenticationMethodType(authenticationMethodType == null ? null : authenticationMethodType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationAuthenticationMethodRequest build() {
            return new GetApplicationAuthenticationMethodRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationAuthenticationMethodRequest> {
        public Builder applicationArn(String var1);

        public Builder authenticationMethodType(String var1);

        public Builder authenticationMethodType(AuthenticationMethodType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

