/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignmentForPrincipal;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse;

public class ListApplicationAssignmentsForPrincipalIterable
implements SdkIterable<ListApplicationAssignmentsForPrincipalResponse> {
    private final SsoAdminClient client;
    private final ListApplicationAssignmentsForPrincipalRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationAssignmentsForPrincipalIterable(SsoAdminClient client, ListApplicationAssignmentsForPrincipalRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationAssignmentsForPrincipalResponseFetcher();
    }

    public Iterator<ListApplicationAssignmentsForPrincipalResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationAssignmentForPrincipal> applicationAssignments() {
        Function<ListApplicationAssignmentsForPrincipalResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssignments() != null) {
                return response.applicationAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationAssignmentsForPrincipalResponseFetcher
    implements SyncPageFetcher<ListApplicationAssignmentsForPrincipalResponse> {
        private ListApplicationAssignmentsForPrincipalResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationAssignmentsForPrincipalResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationAssignmentsForPrincipalResponse nextPage(ListApplicationAssignmentsForPrincipalResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssignmentsForPrincipalIterable.this.client.listApplicationAssignmentsForPrincipal(ListApplicationAssignmentsForPrincipalIterable.this.firstRequest);
            }
            return ListApplicationAssignmentsForPrincipalIterable.this.client.listApplicationAssignmentsForPrincipal((ListApplicationAssignmentsForPrincipalRequest)((Object)ListApplicationAssignmentsForPrincipalIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

