/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem;
import software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodsCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationAuthenticationMethodsResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListApplicationAuthenticationMethodsResponse> {
    private static final SdkField<List<AuthenticationMethodItem>> AUTHENTICATION_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthenticationMethods").getter(ListApplicationAuthenticationMethodsResponse.getter(ListApplicationAuthenticationMethodsResponse::authenticationMethods)).setter(ListApplicationAuthenticationMethodsResponse.setter(Builder::authenticationMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthenticationMethodItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationAuthenticationMethodsResponse.getter(ListApplicationAuthenticationMethodsResponse::nextToken)).setter(ListApplicationAuthenticationMethodsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_METHODS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationAuthenticationMethodsResponse.memberNameToFieldInitializer();
    private final List<AuthenticationMethodItem> authenticationMethods;
    private final String nextToken;

    private ListApplicationAuthenticationMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationMethods = builder.authenticationMethods;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthenticationMethods() {
        return this.authenticationMethods != null && !(this.authenticationMethods instanceof SdkAutoConstructList);
    }

    public final List<AuthenticationMethodItem> authenticationMethods() {
        return this.authenticationMethods;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationMethods() ? this.authenticationMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAuthenticationMethodsResponse)) {
            return false;
        }
        ListApplicationAuthenticationMethodsResponse other = (ListApplicationAuthenticationMethodsResponse)((Object)obj);
        return this.hasAuthenticationMethods() == other.hasAuthenticationMethods() && Objects.equals(this.authenticationMethods(), other.authenticationMethods()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationAuthenticationMethodsResponse").add("AuthenticationMethods", this.hasAuthenticationMethods() ? this.authenticationMethods() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationMethods": {
                return Optional.ofNullable(clazz.cast(this.authenticationMethods()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationMethods", AUTHENTICATION_METHODS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAuthenticationMethodsResponse, T> g) {
        return obj -> g.apply((ListApplicationAuthenticationMethodsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<AuthenticationMethodItem> authenticationMethods = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAuthenticationMethodsResponse model) {
            super(model);
            this.authenticationMethods(model.authenticationMethods);
            this.nextToken(model.nextToken);
        }

        public final List<AuthenticationMethodItem.Builder> getAuthenticationMethods() {
            List<AuthenticationMethodItem.Builder> result = AuthenticationMethodsCopier.copyToBuilder(this.authenticationMethods);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationMethods(Collection<AuthenticationMethodItem.BuilderImpl> authenticationMethods) {
            this.authenticationMethods = AuthenticationMethodsCopier.copyFromBuilder(authenticationMethods);
        }

        @Override
        public final Builder authenticationMethods(Collection<AuthenticationMethodItem> authenticationMethods) {
            this.authenticationMethods = AuthenticationMethodsCopier.copy(authenticationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationMethods(AuthenticationMethodItem ... authenticationMethods) {
            this.authenticationMethods(Arrays.asList(authenticationMethods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationMethods(Consumer<AuthenticationMethodItem.Builder> ... authenticationMethods) {
            this.authenticationMethods(Stream.of(authenticationMethods).map(c -> (AuthenticationMethodItem)((AuthenticationMethodItem.Builder)AuthenticationMethodItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationAuthenticationMethodsResponse build() {
            return new ListApplicationAuthenticationMethodsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationAuthenticationMethodsResponse> {
        public Builder authenticationMethods(Collection<AuthenticationMethodItem> var1);

        public Builder authenticationMethods(AuthenticationMethodItem ... var1);

        public Builder authenticationMethods(Consumer<AuthenticationMethodItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

