/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SignInOrigin;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignInOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignInOptions> {
    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationUrl").getter(SignInOptions.getter(SignInOptions::applicationUrl)).setter(SignInOptions.setter(Builder::applicationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationUrl").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(SignInOptions.getter(SignInOptions::originAsString)).setter(SignInOptions.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_URL_FIELD, ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationUrl", APPLICATION_URL_FIELD);
            this.put("Origin", ORIGIN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationUrl;
    private final String origin;

    private SignInOptions(BuilderImpl builder) {
        this.applicationUrl = builder.applicationUrl;
        this.origin = builder.origin;
    }

    public final String applicationUrl() {
        return this.applicationUrl;
    }

    public final SignInOrigin origin() {
        return SignInOrigin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInOptions)) {
            return false;
        }
        SignInOptions other = (SignInOptions)obj;
        return Objects.equals(this.applicationUrl(), other.applicationUrl()) && Objects.equals(this.originAsString(), other.originAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SignInOptions").add("ApplicationUrl", (Object)this.applicationUrl()).add("Origin", (Object)this.originAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationUrl": {
                return Optional.ofNullable(clazz.cast(this.applicationUrl()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SignInOptions, T> g) {
        return obj -> g.apply((SignInOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationUrl;
        private String origin;

        private BuilderImpl() {
        }

        private BuilderImpl(SignInOptions model) {
            this.applicationUrl(model.applicationUrl);
            this.origin(model.origin);
        }

        public final String getApplicationUrl() {
            return this.applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(SignInOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public SignInOptions build() {
            return new SignInOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignInOptions> {
        public Builder applicationUrl(String var1);

        public Builder origin(String var1);

        public Builder origin(SignInOrigin var1);
    }
}

