/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsFilter;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountAssignmentsForPrincipalRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, ListAccountAssignmentsForPrincipalRequest> {
    private static final SdkField<ListAccountAssignmentsFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::filter)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::filter)).constructor(ListAccountAssignmentsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::instanceArn)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::maxResults)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::nextToken)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::principalId)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(ListAccountAssignmentsForPrincipalRequest.getter(ListAccountAssignmentsForPrincipalRequest::principalTypeAsString)).setter(ListAccountAssignmentsForPrincipalRequest.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, INSTANCE_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Filter", FILTER_FIELD);
            this.put("InstanceArn", INSTANCE_ARN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("PrincipalId", PRINCIPAL_ID_FIELD);
            this.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        }
    });
    private final ListAccountAssignmentsFilter filter;
    private final String instanceArn;
    private final Integer maxResults;
    private final String nextToken;
    private final String principalId;
    private final String principalType;

    private ListAccountAssignmentsForPrincipalRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.instanceArn = builder.instanceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
    }

    public final ListAccountAssignmentsFilter filter() {
        return this.filter;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentsForPrincipalRequest)) {
            return false;
        }
        ListAccountAssignmentsForPrincipalRequest other = (ListAccountAssignmentsForPrincipalRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountAssignmentsForPrincipalRequest").add("Filter", (Object)this.filter()).add("InstanceArn", (Object)this.instanceArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentsForPrincipalRequest, T> g) {
        return obj -> g.apply((ListAccountAssignmentsForPrincipalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private ListAccountAssignmentsFilter filter;
        private String instanceArn;
        private Integer maxResults;
        private String nextToken;
        private String principalId;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentsForPrincipalRequest model) {
            super(model);
            this.filter(model.filter);
            this.instanceArn(model.instanceArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
        }

        public final ListAccountAssignmentsFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(ListAccountAssignmentsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListAccountAssignmentsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountAssignmentsForPrincipalRequest build() {
            return new ListAccountAssignmentsForPrincipalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountAssignmentsForPrincipalRequest> {
        public Builder filter(ListAccountAssignmentsFilter var1);

        default public Builder filter(Consumer<ListAccountAssignmentsFilter.Builder> filter) {
            return this.filter((ListAccountAssignmentsFilter)((ListAccountAssignmentsFilter.Builder)ListAccountAssignmentsFilter.builder().applyMutation(filter)).build());
        }

        public Builder instanceArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

