/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignment;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountAssignmentsResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListAccountAssignmentsResponse> {
    private static final SdkField<List<AccountAssignment>> ACCOUNT_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAssignments").getter(ListAccountAssignmentsResponse.getter(ListAccountAssignmentsResponse::accountAssignments)).setter(ListAccountAssignmentsResponse.setter(Builder::accountAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccountAssignmentsResponse.getter(ListAccountAssignmentsResponse::nextToken)).setter(ListAccountAssignmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSIGNMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountAssignments", ACCOUNT_ASSIGNMENTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AccountAssignment> accountAssignments;
    private final String nextToken;

    private ListAccountAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignments = builder.accountAssignments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountAssignments() {
        return this.accountAssignments != null && !(this.accountAssignments instanceof SdkAutoConstructList);
    }

    public final List<AccountAssignment> accountAssignments() {
        return this.accountAssignments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAssignments() ? this.accountAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentsResponse)) {
            return false;
        }
        ListAccountAssignmentsResponse other = (ListAccountAssignmentsResponse)((Object)obj);
        return this.hasAccountAssignments() == other.hasAccountAssignments() && Objects.equals(this.accountAssignments(), other.accountAssignments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountAssignmentsResponse").add("AccountAssignments", this.hasAccountAssignments() ? this.accountAssignments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAssignments": {
                return Optional.ofNullable(clazz.cast(this.accountAssignments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentsResponse, T> g) {
        return obj -> g.apply((ListAccountAssignmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<AccountAssignment> accountAssignments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentsResponse model) {
            super(model);
            this.accountAssignments(model.accountAssignments);
            this.nextToken(model.nextToken);
        }

        public final List<AccountAssignment.Builder> getAccountAssignments() {
            List<AccountAssignment.Builder> result = AccountAssignmentListCopier.copyToBuilder(this.accountAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAssignments(Collection<AccountAssignment.BuilderImpl> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copyFromBuilder(accountAssignments);
        }

        @Override
        public final Builder accountAssignments(Collection<AccountAssignment> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copy(accountAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(AccountAssignment ... accountAssignments) {
            this.accountAssignments(Arrays.asList(accountAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(Consumer<AccountAssignment.Builder> ... accountAssignments) {
            this.accountAssignments(Stream.of(accountAssignments).map(c -> (AccountAssignment)((AccountAssignment.Builder)AccountAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccountAssignmentsResponse build() {
            return new ListAccountAssignmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountAssignmentsResponse> {
        public Builder accountAssignments(Collection<AccountAssignment> var1);

        public Builder accountAssignments(AccountAssignment ... var1);

        public Builder accountAssignments(Consumer<AccountAssignment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

