/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssoadmin.model.ResourceServerScopeDetails;
import software.amazon.awssdk.services.ssoadmin.model.ResourceServerScopesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceServerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceServerConfig> {
    private static final SdkField<Map<String, ResourceServerScopeDetails>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Scopes").getter(ResourceServerConfig.getter(ResourceServerConfig::scopes)).setter(ResourceServerConfig.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceServerScopeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Scopes", SCOPES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, ResourceServerScopeDetails> scopes;

    private ResourceServerConfig(BuilderImpl builder) {
        this.scopes = builder.scopes;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructMap);
    }

    public final Map<String, ResourceServerScopeDetails> scopes() {
        return this.scopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerConfig)) {
            return false;
        }
        ResourceServerConfig other = (ResourceServerConfig)obj;
        return this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceServerConfig").add("Scopes", this.hasScopes() ? this.scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceServerConfig, T> g) {
        return obj -> g.apply((ResourceServerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ResourceServerScopeDetails> scopes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerConfig model) {
            this.scopes(model.scopes);
        }

        public final Map<String, ResourceServerScopeDetails.Builder> getScopes() {
            Map<String, ResourceServerScopeDetails.Builder> result = ResourceServerScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setScopes(Map<String, ResourceServerScopeDetails.BuilderImpl> scopes) {
            this.scopes = ResourceServerScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Map<String, ResourceServerScopeDetails> scopes) {
            this.scopes = ResourceServerScopesCopier.copy(scopes);
            return this;
        }

        public ResourceServerConfig build() {
            return new ResourceServerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceServerConfig> {
        public Builder scopes(Map<String, ResourceServerScopeDetails> var1);
    }
}

