/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationProvider;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationProviderListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationProvidersResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListApplicationProvidersResponse> {
    private static final SdkField<List<ApplicationProvider>> APPLICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationProviders").getter(ListApplicationProvidersResponse.getter(ListApplicationProvidersResponse::applicationProviders)).setter(ListApplicationProvidersResponse.setter(Builder::applicationProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationProvidersResponse.getter(ListApplicationProvidersResponse::nextToken)).setter(ListApplicationProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationProvider> applicationProviders;
    private final String nextToken;

    private ListApplicationProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.applicationProviders = builder.applicationProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationProviders() {
        return this.applicationProviders != null && !(this.applicationProviders instanceof SdkAutoConstructList);
    }

    public final List<ApplicationProvider> applicationProviders() {
        return this.applicationProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationProviders() ? this.applicationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationProvidersResponse)) {
            return false;
        }
        ListApplicationProvidersResponse other = (ListApplicationProvidersResponse)((Object)obj);
        return this.hasApplicationProviders() == other.hasApplicationProviders() && Objects.equals(this.applicationProviders(), other.applicationProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationProvidersResponse").add("ApplicationProviders", this.hasApplicationProviders() ? this.applicationProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationProviders": {
                return Optional.ofNullable(clazz.cast(this.applicationProviders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationProvidersResponse, T> g) {
        return obj -> g.apply((ListApplicationProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<ApplicationProvider> applicationProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationProvidersResponse model) {
            super(model);
            this.applicationProviders(model.applicationProviders);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationProvider.Builder> getApplicationProviders() {
            List<ApplicationProvider.Builder> result = ApplicationProviderListCopier.copyToBuilder(this.applicationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationProviders(Collection<ApplicationProvider.BuilderImpl> applicationProviders) {
            this.applicationProviders = ApplicationProviderListCopier.copyFromBuilder(applicationProviders);
        }

        @Override
        public final Builder applicationProviders(Collection<ApplicationProvider> applicationProviders) {
            this.applicationProviders = ApplicationProviderListCopier.copy(applicationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationProviders(ApplicationProvider ... applicationProviders) {
            this.applicationProviders(Arrays.asList(applicationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationProviders(Consumer<ApplicationProvider.Builder> ... applicationProviders) {
            this.applicationProviders(Stream.of(applicationProviders).map(c -> (ApplicationProvider)((ApplicationProvider.Builder)ApplicationProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationProvidersResponse build() {
            return new ListApplicationProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationProvidersResponse> {
        public Builder applicationProviders(Collection<ApplicationProvider> var1);

        public Builder applicationProviders(ApplicationProvider ... var1);

        public Builder applicationProviders(Consumer<ApplicationProvider.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

