/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.Grant;
import software.amazon.awssdk.services.ssoadmin.model.GrantType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationGrantRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, PutApplicationGrantRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::applicationArn)).setter(PutApplicationGrantRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<Grant> GRANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Grant").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::grant)).setter(PutApplicationGrantRequest.setter(Builder::grant)).constructor(Grant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grant").build()}).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantType").getter(PutApplicationGrantRequest.getter(PutApplicationGrantRequest::grantTypeAsString)).setter(PutApplicationGrantRequest.setter(Builder::grantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, GRANT_FIELD, GRANT_TYPE_FIELD));
    private final String applicationArn;
    private final Grant grant;
    private final String grantType;

    private PutApplicationGrantRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.grant = builder.grant;
        this.grantType = builder.grantType;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final Grant grant() {
        return this.grant;
    }

    public final GrantType grantType() {
        return GrantType.fromValue(this.grantType);
    }

    public final String grantTypeAsString() {
        return this.grantType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grant());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationGrantRequest)) {
            return false;
        }
        PutApplicationGrantRequest other = (PutApplicationGrantRequest)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.grant(), other.grant()) && Objects.equals(this.grantTypeAsString(), other.grantTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutApplicationGrantRequest").add("ApplicationArn", (Object)this.applicationArn()).add("Grant", (Object)this.grant()).add("GrantType", (Object)this.grantTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "Grant": {
                return Optional.ofNullable(clazz.cast(this.grant()));
            }
            case "GrantType": {
                return Optional.ofNullable(clazz.cast(this.grantTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationGrantRequest, T> g) {
        return obj -> g.apply((PutApplicationGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private Grant grant;
        private String grantType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationGrantRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.grant(model.grant);
            this.grantType(model.grantType);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Grant.Builder getGrant() {
            return this.grant != null ? this.grant.toBuilder() : null;
        }

        public final void setGrant(Grant.BuilderImpl grant) {
            this.grant = grant != null ? grant.build() : null;
        }

        @Override
        public final Builder grant(Grant grant) {
            this.grant = grant;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public final Builder grantType(GrantType grantType) {
            this.grantType(grantType == null ? null : grantType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationGrantRequest build() {
            return new PutApplicationGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutApplicationGrantRequest> {
        public Builder applicationArn(String var1);

        public Builder grant(Grant var1);

        default public Builder grant(Consumer<Grant.Builder> grant) {
            return this.grant((Grant)((Grant.Builder)Grant.builder().applyMutation(grant)).build());
        }

        public Builder grantType(String var1);

        public Builder grantType(GrantType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

