/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerListCopier;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustedTokenIssuersResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListTrustedTokenIssuersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrustedTokenIssuersResponse.getter(ListTrustedTokenIssuersResponse::nextToken)).setter(ListTrustedTokenIssuersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TrustedTokenIssuerMetadata>> TRUSTED_TOKEN_ISSUERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustedTokenIssuers").getter(ListTrustedTokenIssuersResponse.getter(ListTrustedTokenIssuersResponse::trustedTokenIssuers)).setter(ListTrustedTokenIssuersResponse.setter(Builder::trustedTokenIssuers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedTokenIssuerMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRUSTED_TOKEN_ISSUERS_FIELD));
    private final String nextToken;
    private final List<TrustedTokenIssuerMetadata> trustedTokenIssuers;

    private ListTrustedTokenIssuersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trustedTokenIssuers = builder.trustedTokenIssuers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrustedTokenIssuers() {
        return this.trustedTokenIssuers != null && !(this.trustedTokenIssuers instanceof SdkAutoConstructList);
    }

    public final List<TrustedTokenIssuerMetadata> trustedTokenIssuers() {
        return this.trustedTokenIssuers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustedTokenIssuers() ? this.trustedTokenIssuers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustedTokenIssuersResponse)) {
            return false;
        }
        ListTrustedTokenIssuersResponse other = (ListTrustedTokenIssuersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrustedTokenIssuers() == other.hasTrustedTokenIssuers() && Objects.equals(this.trustedTokenIssuers(), other.trustedTokenIssuers());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustedTokenIssuersResponse").add("NextToken", (Object)this.nextToken()).add("TrustedTokenIssuers", this.hasTrustedTokenIssuers() ? this.trustedTokenIssuers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TrustedTokenIssuers": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrustedTokenIssuersResponse, T> g) {
        return obj -> g.apply((ListTrustedTokenIssuersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrustedTokenIssuerMetadata> trustedTokenIssuers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustedTokenIssuersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trustedTokenIssuers(model.trustedTokenIssuers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrustedTokenIssuerMetadata.Builder> getTrustedTokenIssuers() {
            List<TrustedTokenIssuerMetadata.Builder> result = TrustedTokenIssuerListCopier.copyToBuilder(this.trustedTokenIssuers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustedTokenIssuers(Collection<TrustedTokenIssuerMetadata.BuilderImpl> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copyFromBuilder(trustedTokenIssuers);
        }

        @Override
        public final Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copy(trustedTokenIssuers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(TrustedTokenIssuerMetadata ... trustedTokenIssuers) {
            this.trustedTokenIssuers(Arrays.asList(trustedTokenIssuers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder> ... trustedTokenIssuers) {
            this.trustedTokenIssuers(Stream.of(trustedTokenIssuers).map(c -> (TrustedTokenIssuerMetadata)((TrustedTokenIssuerMetadata.Builder)TrustedTokenIssuerMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustedTokenIssuersResponse build() {
            return new ListTrustedTokenIssuersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustedTokenIssuersResponse> {
        public Builder nextToken(String var1);

        public Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> var1);

        public Builder trustedTokenIssuers(TrustedTokenIssuerMetadata ... var1);

        public Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder> ... var1);
    }
}

