/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;

public class ListAccountsForProvisionedPermissionSetPublisher
implements SdkPublisher<ListAccountsForProvisionedPermissionSetResponse> {
    private final SsoAdminAsyncClient client;
    private final ListAccountsForProvisionedPermissionSetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsForProvisionedPermissionSetPublisher(SsoAdminAsyncClient client, ListAccountsForProvisionedPermissionSetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsForProvisionedPermissionSetPublisher(SsoAdminAsyncClient client, ListAccountsForProvisionedPermissionSetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsForProvisionedPermissionSetResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsForProvisionedPermissionSetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> accountIds() {
        Function<ListAccountsForProvisionedPermissionSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountIds() != null) {
                return response.accountIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountsForProvisionedPermissionSetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountsForProvisionedPermissionSetResponseFetcher
    implements AsyncPageFetcher<ListAccountsForProvisionedPermissionSetResponse> {
        private ListAccountsForProvisionedPermissionSetResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForProvisionedPermissionSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> nextPage(ListAccountsForProvisionedPermissionSetResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForProvisionedPermissionSetPublisher.this.client.listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetPublisher.this.firstRequest);
            }
            return ListAccountsForProvisionedPermissionSetPublisher.this.client.listAccountsForProvisionedPermissionSet((ListAccountsForProvisionedPermissionSetRequest)((Object)ListAccountsForProvisionedPermissionSetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

