/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions
 * boundary. Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed
 * policy, or <code>ManagedPolicyArn</code> to use the ARN of an AWS managed policy. A permissions boundary represents
 * the maximum permissions that any policy can grant your role. For more information, see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for
 * IAM entities</a> in the <i>IAM User Guide</i>.
 * </p>
 * <important>
 * <p>
 * Policies used as permissions boundaries don't provide permissions. You must also attach an IAM policy to the role. To
 * learn how the effective permissions for a role are evaluated, see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
 * evaluation logic</a> in the <i>IAM User Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionsBoundary implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionsBoundary.Builder, PermissionsBoundary> {
    private static final SdkField<CustomerManagedPolicyReference> CUSTOMER_MANAGED_POLICY_REFERENCE_FIELD = SdkField
            .<CustomerManagedPolicyReference> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerManagedPolicyReference")
            .getter(getter(PermissionsBoundary::customerManagedPolicyReference))
            .setter(setter(Builder::customerManagedPolicyReference))
            .constructor(CustomerManagedPolicyReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedPolicyReference")
                    .build()).build();

    private static final SdkField<String> MANAGED_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedPolicyArn").getter(getter(PermissionsBoundary::managedPolicyArn))
            .setter(setter(Builder::managedPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedPolicyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_MANAGED_POLICY_REFERENCE_FIELD, MANAGED_POLICY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomerManagedPolicyReference customerManagedPolicyReference;

    private final String managedPolicyArn;

    private PermissionsBoundary(BuilderImpl builder) {
        this.customerManagedPolicyReference = builder.customerManagedPolicyReference;
        this.managedPolicyArn = builder.managedPolicyArn;
    }

    /**
     * <p>
     * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and
     * path in each AWS account where you want to deploy your permission set.
     * </p>
     * 
     * @return Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the
     *         name and path in each AWS account where you want to deploy your permission set.
     */
    public final CustomerManagedPolicyReference customerManagedPolicyReference() {
        return customerManagedPolicyReference;
    }

    /**
     * <p>
     * The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
     * </p>
     * 
     * @return The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
     */
    public final String managedPolicyArn() {
        return managedPolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedPolicyReference());
        hashCode = 31 * hashCode + Objects.hashCode(managedPolicyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionsBoundary)) {
            return false;
        }
        PermissionsBoundary other = (PermissionsBoundary) obj;
        return Objects.equals(customerManagedPolicyReference(), other.customerManagedPolicyReference())
                && Objects.equals(managedPolicyArn(), other.managedPolicyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionsBoundary").add("CustomerManagedPolicyReference", customerManagedPolicyReference())
                .add("ManagedPolicyArn", managedPolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerManagedPolicyReference":
            return Optional.ofNullable(clazz.cast(customerManagedPolicyReference()));
        case "ManagedPolicyArn":
            return Optional.ofNullable(clazz.cast(managedPolicyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionsBoundary, T> g) {
        return obj -> g.apply((PermissionsBoundary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionsBoundary> {
        /**
         * <p>
         * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name
         * and path in each AWS account where you want to deploy your permission set.
         * </p>
         * 
         * @param customerManagedPolicyReference
         *        Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the
         *        name and path in each AWS account where you want to deploy your permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedPolicyReference(CustomerManagedPolicyReference customerManagedPolicyReference);

        /**
         * <p>
         * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name
         * and path in each AWS account where you want to deploy your permission set.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerManagedPolicyReference.Builder}
         * avoiding the need to create one manually via {@link CustomerManagedPolicyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedPolicyReference.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customerManagedPolicyReference(CustomerManagedPolicyReference)}.
         * 
         * @param customerManagedPolicyReference
         *        a consumer that will call methods on {@link CustomerManagedPolicyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedPolicyReference(CustomerManagedPolicyReference)
         */
        default Builder customerManagedPolicyReference(
                Consumer<CustomerManagedPolicyReference.Builder> customerManagedPolicyReference) {
            return customerManagedPolicyReference(CustomerManagedPolicyReference.builder()
                    .applyMutation(customerManagedPolicyReference).build());
        }

        /**
         * <p>
         * The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
         * </p>
         * 
         * @param managedPolicyArn
         *        The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArn(String managedPolicyArn);
    }

    static final class BuilderImpl implements Builder {
        private CustomerManagedPolicyReference customerManagedPolicyReference;

        private String managedPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionsBoundary model) {
            customerManagedPolicyReference(model.customerManagedPolicyReference);
            managedPolicyArn(model.managedPolicyArn);
        }

        public final CustomerManagedPolicyReference.Builder getCustomerManagedPolicyReference() {
            return customerManagedPolicyReference != null ? customerManagedPolicyReference.toBuilder() : null;
        }

        public final void setCustomerManagedPolicyReference(
                CustomerManagedPolicyReference.BuilderImpl customerManagedPolicyReference) {
            this.customerManagedPolicyReference = customerManagedPolicyReference != null ? customerManagedPolicyReference.build()
                    : null;
        }

        @Override
        public final Builder customerManagedPolicyReference(CustomerManagedPolicyReference customerManagedPolicyReference) {
            this.customerManagedPolicyReference = customerManagedPolicyReference;
            return this;
        }

        public final String getManagedPolicyArn() {
            return managedPolicyArn;
        }

        public final void setManagedPolicyArn(String managedPolicyArn) {
            this.managedPolicyArn = managedPolicyArn;
        }

        @Override
        public final Builder managedPolicyArn(String managedPolicyArn) {
            this.managedPolicyArn = managedPolicyArn;
            return this;
        }

        @Override
        public PermissionsBoundary build() {
            return new PermissionsBoundary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
