/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPermissionsBoundaryForPermissionSetResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetPermissionsBoundaryForPermissionSetResponse.Builder, GetPermissionsBoundaryForPermissionSetResponse> {
    private static final SdkField<PermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<PermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(GetPermissionsBoundaryForPermissionSetResponse::permissionsBoundary))
            .setter(setter(Builder::permissionsBoundary)).constructor(PermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_BOUNDARY_FIELD));

    private final PermissionsBoundary permissionsBoundary;

    private GetPermissionsBoundaryForPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    /**
     * <p>
     * The permissions boundary attached to the specified permission set.
     * </p>
     * 
     * @return The permissions boundary attached to the specified permission set.
     */
    public final PermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPermissionsBoundaryForPermissionSetResponse)) {
            return false;
        }
        GetPermissionsBoundaryForPermissionSetResponse other = (GetPermissionsBoundaryForPermissionSetResponse) obj;
        return Objects.equals(permissionsBoundary(), other.permissionsBoundary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPermissionsBoundaryForPermissionSetResponse")
                .add("PermissionsBoundary", permissionsBoundary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPermissionsBoundaryForPermissionSetResponse, T> g) {
        return obj -> g.apply((GetPermissionsBoundaryForPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPermissionsBoundaryForPermissionSetResponse> {
        /**
         * <p>
         * The permissions boundary attached to the specified permission set.
         * </p>
         * 
         * @param permissionsBoundary
         *        The permissions boundary attached to the specified permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(PermissionsBoundary permissionsBoundary);

        /**
         * <p>
         * The permissions boundary attached to the specified permission set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionsBoundary.Builder} avoiding the
         * need to create one manually via {@link PermissionsBoundary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionsBoundary.Builder#build()} is called immediately and
         * its result is passed to {@link #permissionsBoundary(PermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link PermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(PermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<PermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(PermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private PermissionsBoundary permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPermissionsBoundaryForPermissionSetResponse model) {
            super(model);
            permissionsBoundary(model.permissionsBoundary);
        }

        public final PermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(PermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(PermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        @Override
        public GetPermissionsBoundaryForPermissionSetResponse build() {
            return new GetPermissionsBoundaryForPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
