/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountAssignmentResponse extends SsoAdminResponse implements
        ToCopyableBuilder<CreateAccountAssignmentResponse.Builder, CreateAccountAssignmentResponse> {
    private static final SdkField<AccountAssignmentOperationStatus> ACCOUNT_ASSIGNMENT_CREATION_STATUS_FIELD = SdkField
            .<AccountAssignmentOperationStatus> builder(MarshallingType.SDK_POJO)
            .memberName("AccountAssignmentCreationStatus")
            .getter(getter(CreateAccountAssignmentResponse::accountAssignmentCreationStatus))
            .setter(setter(Builder::accountAssignmentCreationStatus))
            .constructor(AccountAssignmentOperationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentCreationStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ASSIGNMENT_CREATION_STATUS_FIELD));

    private final AccountAssignmentOperationStatus accountAssignmentCreationStatus;

    private CreateAccountAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignmentCreationStatus = builder.accountAssignmentCreationStatus;
    }

    /**
     * <p>
     * The status object for the account assignment creation operation.
     * </p>
     * 
     * @return The status object for the account assignment creation operation.
     */
    public final AccountAssignmentOperationStatus accountAssignmentCreationStatus() {
        return accountAssignmentCreationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignmentCreationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountAssignmentResponse)) {
            return false;
        }
        CreateAccountAssignmentResponse other = (CreateAccountAssignmentResponse) obj;
        return Objects.equals(accountAssignmentCreationStatus(), other.accountAssignmentCreationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccountAssignmentResponse")
                .add("AccountAssignmentCreationStatus", accountAssignmentCreationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssignmentCreationStatus":
            return Optional.ofNullable(clazz.cast(accountAssignmentCreationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountAssignmentResponse, T> g) {
        return obj -> g.apply((CreateAccountAssignmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccountAssignmentResponse> {
        /**
         * <p>
         * The status object for the account assignment creation operation.
         * </p>
         * 
         * @param accountAssignmentCreationStatus
         *        The status object for the account assignment creation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentCreationStatus(AccountAssignmentOperationStatus accountAssignmentCreationStatus);

        /**
         * <p>
         * The status object for the account assignment creation operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountAssignmentOperationStatus.Builder}
         * avoiding the need to create one manually via {@link AccountAssignmentOperationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountAssignmentOperationStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accountAssignmentCreationStatus(AccountAssignmentOperationStatus)}.
         * 
         * @param accountAssignmentCreationStatus
         *        a consumer that will call methods on {@link AccountAssignmentOperationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAssignmentCreationStatus(AccountAssignmentOperationStatus)
         */
        default Builder accountAssignmentCreationStatus(
                Consumer<AccountAssignmentOperationStatus.Builder> accountAssignmentCreationStatus) {
            return accountAssignmentCreationStatus(AccountAssignmentOperationStatus.builder()
                    .applyMutation(accountAssignmentCreationStatus).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private AccountAssignmentOperationStatus accountAssignmentCreationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountAssignmentResponse model) {
            super(model);
            accountAssignmentCreationStatus(model.accountAssignmentCreationStatus);
        }

        public final AccountAssignmentOperationStatus.Builder getAccountAssignmentCreationStatus() {
            return accountAssignmentCreationStatus != null ? accountAssignmentCreationStatus.toBuilder() : null;
        }

        public final void setAccountAssignmentCreationStatus(
                AccountAssignmentOperationStatus.BuilderImpl accountAssignmentCreationStatus) {
            this.accountAssignmentCreationStatus = accountAssignmentCreationStatus != null ? accountAssignmentCreationStatus
                    .build() : null;
        }

        @Override
        public final Builder accountAssignmentCreationStatus(AccountAssignmentOperationStatus accountAssignmentCreationStatus) {
            this.accountAssignmentCreationStatus = accountAssignmentCreationStatus;
            return this;
        }

        @Override
        public CreateAccountAssignmentResponse build() {
            return new CreateAccountAssignmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
