/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the creation or deletion operation of an assignment that a principal needs to access an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAssignmentOperationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAssignmentOperationStatus.Builder, AccountAssignmentOperationStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AccountAssignmentOperationStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(AccountAssignmentOperationStatus::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AccountAssignmentOperationStatus::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(AccountAssignmentOperationStatus::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(AccountAssignmentOperationStatus::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(AccountAssignmentOperationStatus::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(AccountAssignmentOperationStatus::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(AccountAssignmentOperationStatus::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(AccountAssignmentOperationStatus::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            REQUEST_ID_FIELD, FAILURE_REASON_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, PERMISSION_SET_ARN_FIELD,
            PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD, CREATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String requestId;

    private final String failureReason;

    private final String targetId;

    private final String targetType;

    private final String permissionSetArn;

    private final String principalType;

    private final String principalId;

    private final Instant createdDate;

    private AccountAssignmentOperationStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.failureReason = builder.failureReason;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final StatusValues status() {
        return StatusValues.fromValue(status);
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID)
     * workflow.
     * </p>
     * 
     * @return The identifier for tracking the request operation that is generated by the universally unique identifier
     *         (UUID) workflow.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The message that contains an error or exception in case of an operation failure.
     * </p>
     * 
     * @return The message that contains an error or exception in case of an operation failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
     * </p>
     * 
     * @return TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     * Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the permission set. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     *         Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example,
     * f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API
     * Reference</a>.
     * </p>
     * 
     * @return An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For
     *         example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity
     *         Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center
     *         Identity Store API Reference</a>.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The date that the permission set was created.
     * </p>
     * 
     * @return The date that the permission set was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssignmentOperationStatus)) {
            return false;
        }
        AccountAssignmentOperationStatus other = (AccountAssignmentOperationStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(principalId(), other.principalId()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAssignmentOperationStatus").add("Status", statusAsString()).add("RequestId", requestId())
                .add("FailureReason", failureReason()).add("TargetId", targetId()).add("TargetType", targetTypeAsString())
                .add("PermissionSetArn", permissionSetArn()).add("PrincipalType", principalTypeAsString())
                .add("PrincipalId", principalId()).add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAssignmentOperationStatus, T> g) {
        return obj -> g.apply((AccountAssignmentOperationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAssignmentOperationStatus> {
        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(StatusValues status);

        /**
         * <p>
         * The identifier for tracking the request operation that is generated by the universally unique identifier
         * (UUID) workflow.
         * </p>
         * 
         * @param requestId
         *        The identifier for tracking the request operation that is generated by the universally unique
         *        identifier (UUID) workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The message that contains an error or exception in case of an operation failure.
         * </p>
         * 
         * @param failureReason
         *        The message that contains an error or exception in case of an operation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
         * </p>
         * 
         * @param targetId
         *        TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * The ARN of the permission set. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         * Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         *        Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For
         * example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity
         * Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center
         * Identity Store API Reference</a>.
         * </p>
         * 
         * @param principalId
         *        An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs
         *        (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM
         *        Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM
         *        Identity Center Identity Store API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The date that the permission set was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the permission set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String requestId;

        private String failureReason;

        private String targetId;

        private String targetType;

        private String permissionSetArn;

        private String principalType;

        private String principalId;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssignmentOperationStatus model) {
            status(model.status);
            requestId(model.requestId);
            failureReason(model.failureReason);
            targetId(model.targetId);
            targetType(model.targetType);
            permissionSetArn(model.permissionSetArn);
            principalType(model.principalType);
            principalId(model.principalId);
            createdDate(model.createdDate);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusValues status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public AccountAssignmentOperationStatus build() {
            return new AccountAssignmentOperationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
