/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata;

public class ListPermissionSetProvisioningStatusPublisher
implements SdkPublisher<ListPermissionSetProvisioningStatusResponse> {
    private final SsoAdminAsyncClient client;
    private final ListPermissionSetProvisioningStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionSetProvisioningStatusPublisher(SsoAdminAsyncClient client, ListPermissionSetProvisioningStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionSetProvisioningStatusPublisher(SsoAdminAsyncClient client, ListPermissionSetProvisioningStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionSetProvisioningStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionSetProvisioningStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus() {
        Function<ListPermissionSetProvisioningStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionSetsProvisioningStatus() != null) {
                return response.permissionSetsProvisioningStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPermissionSetProvisioningStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPermissionSetProvisioningStatusResponseFetcher
    implements AsyncPageFetcher<ListPermissionSetProvisioningStatusResponse> {
        private ListPermissionSetProvisioningStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionSetProvisioningStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionSetProvisioningStatusResponse> nextPage(ListPermissionSetProvisioningStatusResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionSetProvisioningStatusPublisher.this.client.listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusPublisher.this.firstRequest);
            }
            return ListPermissionSetProvisioningStatusPublisher.this.client.listPermissionSetProvisioningStatus((ListPermissionSetProvisioningStatusRequest)((Object)ListPermissionSetProvisioningStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

