/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedPoliciesInPermissionSetResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListManagedPoliciesInPermissionSetResponse.Builder, ListManagedPoliciesInPermissionSetResponse> {
    private static final SdkField<List<AttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AttachedManagedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(ListManagedPoliciesInPermissionSetResponse::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedManagedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedManagedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListManagedPoliciesInPermissionSetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTACHED_MANAGED_POLICIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AttachedManagedPolicy> attachedManagedPolicies;

    private final String nextToken;

    private ListManagedPoliciesInPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AttachedManagedPolicies property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of the <a>AttachedManagedPolicy</a> data type object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachedManagedPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of the <a>AttachedManagedPolicy</a> data type object.
     */
    public final List<AttachedManagedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedPoliciesInPermissionSetResponse)) {
            return false;
        }
        ListManagedPoliciesInPermissionSetResponse other = (ListManagedPoliciesInPermissionSetResponse) obj;
        return hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedPoliciesInPermissionSetResponse")
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedPoliciesInPermissionSetResponse, T> g) {
        return obj -> g.apply((ListManagedPoliciesInPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedPoliciesInPermissionSetResponse> {
        /**
         * <p>
         * The array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        The array of the <a>AttachedManagedPolicy</a> data type object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AttachedManagedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * The array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        The array of the <a>AttachedManagedPolicy</a> data type object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AttachedManagedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * The array of the <a>AttachedManagedPolicy</a> data type object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachedManagedPolicy>.Builder} avoiding
         * the need to create one manually via {@link List<AttachedManagedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachedManagedPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachedManagedPolicies(List<AttachedManagedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on {@link List<AttachedManagedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(List<AttachedManagedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AttachedManagedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedPoliciesInPermissionSetResponse model) {
            super(model);
            attachedManagedPolicies(model.attachedManagedPolicies);
            nextToken(model.nextToken);
        }

        public final Collection<AttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            if (attachedManagedPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return attachedManagedPolicies != null ? attachedManagedPolicies.stream().map(AttachedManagedPolicy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedManagedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedManagedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AttachedManagedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListManagedPoliciesInPermissionSetResponse build() {
            return new ListManagedPoliciesInPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
