/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceResourcesRequest
extends SnowDeviceManagementRequest
implements ToCopyableBuilder<Builder, ListDeviceResourcesRequest> {
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(ListDeviceResourcesRequest.getter(ListDeviceResourcesRequest::managedDeviceId)).setter(ListDeviceResourcesRequest.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("managedDeviceId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDeviceResourcesRequest.getter(ListDeviceResourcesRequest::maxResults)).setter(ListDeviceResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeviceResourcesRequest.getter(ListDeviceResourcesRequest::nextToken)).setter(ListDeviceResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ListDeviceResourcesRequest.getter(ListDeviceResourcesRequest::type)).setter(ListDeviceResourcesRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_DEVICE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TYPE_FIELD));
    private final String managedDeviceId;
    private final Integer maxResults;
    private final String nextToken;
    private final String type;

    private ListDeviceResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.managedDeviceId = builder.managedDeviceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.type = builder.type;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceResourcesRequest)) {
            return false;
        }
        ListDeviceResourcesRequest other = (ListDeviceResourcesRequest)((Object)obj);
        return Objects.equals(this.managedDeviceId(), other.managedDeviceId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceResourcesRequest").add("ManagedDeviceId", (Object)this.managedDeviceId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceResourcesRequest, T> g) {
        return obj -> g.apply((ListDeviceResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementRequest.BuilderImpl
    implements Builder {
        private String managedDeviceId;
        private Integer maxResults;
        private String nextToken;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceResourcesRequest model) {
            super(model);
            this.managedDeviceId(model.managedDeviceId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.type(model.type);
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceResourcesRequest build() {
            return new ListDeviceResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceResourcesRequest> {
        public Builder managedDeviceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder type(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

