/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.snowdevicemanagement.DefaultSnowDeviceManagementAsyncClient;
import software.amazon.awssdk.services.snowdevicemanagement.DefaultSnowDeviceManagementBaseClientBuilder;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementAsyncClient;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementAsyncClientBuilder;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementServiceClientConfiguration;
import software.amazon.awssdk.services.snowdevicemanagement.endpoints.SnowDeviceManagementEndpointProvider;

@SdkInternalApi
final class DefaultSnowDeviceManagementAsyncClientBuilder
extends DefaultSnowDeviceManagementBaseClientBuilder<SnowDeviceManagementAsyncClientBuilder, SnowDeviceManagementAsyncClient>
implements SnowDeviceManagementAsyncClientBuilder {
    DefaultSnowDeviceManagementAsyncClientBuilder() {
    }

    @Override
    public DefaultSnowDeviceManagementAsyncClientBuilder endpointProvider(SnowDeviceManagementEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SnowDeviceManagementAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSnowDeviceManagementAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SnowDeviceManagementServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSnowDeviceManagementAsyncClient client = new DefaultSnowDeviceManagementAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SnowDeviceManagementServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SnowDeviceManagementServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

